/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.geometry;

import com.sun.opengl.util.BufferUtil;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class SphereGeometry3
implements GLRenderObject {
    float radius = 5.0f;
    int numSlices = 32;
    int numStacks = 16;
    float[] mat_ambient = new float[]{1.0f, 1.0f, 1.0f};
    float[] mat_diffuse = new float[]{1.0f, 1.0f, 1.0f};
    float[] mat_specular = new float[]{0.0f, 0.0f, 0.0f};
    int texId;
    int nrOfVertices;
    int nrOfTris;
    float[] vertexData;
    float[] normalData;
    float[] texCoordData;
    int[] indexData;
    FloatBuffer vertexBuffer;
    FloatBuffer normalBuffer;
    FloatBuffer texCoordBuffer;
    IntBuffer indexBuffer;
    int vertexBufferId;
    int normalBufferId;
    int indexBufferId;
    int texCoordBufferId;
    int combinedBufferId;
    int combinedSize;
    int combinedByteBufferSize;
    int dataBufferSize;
    int dataByteBufferSize;
    int texCoordBufferSize;
    int texCoordByteBufferSize;
    int indexBufferSize;
    int indexByteBufferSize;
    int vertexOffset;
    int normalOffset;
    int texcoordOffset;
    int glArrayBufferSize;
    private boolean textured = true;
    private static SphereGeometry3 sphere;

    public static void makeSphere(float radius, int numSlices, int numStacks) {
        sphere = new SphereGeometry3(radius, numSlices, numStacks);
    }

    public static SphereGeometry3 getSphere(float radius, int numSlices, int numStacks) {
        if (sphere == null) {
            SphereGeometry3.makeSphere(radius, numSlices, numStacks);
        }
        return sphere;
    }

    public SphereGeometry3(float radius, int numSlices, int numStacks) {
        this.radius = radius;
        this.numSlices = numSlices;
        this.numStacks = numStacks;
        this.init();
    }

    public void setTextured(boolean textured) {
        this.textured = textured;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        int[] bufNames = new int[5];
        gl.glGenBuffers(5, bufNames);
        this.indexBufferId = bufNames[3];
        this.combinedBufferId = bufNames[4];
        gl.glBindBuffer(34962, this.combinedBufferId);
        gl.glBufferData(34962, this.glArrayBufferSize, (FloatBuffer)null, 35044);
        this.vertexBuffer.rewind();
        gl.glBufferSubData(34962, this.vertexOffset, this.dataByteBufferSize, this.vertexBuffer);
        this.normalBuffer.rewind();
        gl.glBufferSubData(34962, this.normalOffset, this.dataByteBufferSize, this.normalBuffer);
        this.texCoordBuffer.rewind();
        gl.glBufferSubData(34962, this.texcoordOffset, this.texCoordByteBufferSize, this.texCoordBuffer);
        gl.glBindBuffer(34963, this.indexBufferId);
        this.indexBuffer.rewind();
        gl.glBufferData(34963, this.indexByteBufferSize, this.indexBuffer, 35044);
        gl.glEnableClientState(32884);
        gl.glEnableClientState(32885);
        gl.glEnableClientState(32888);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        gl.glBindBuffer(34962, this.combinedBufferId);
        gl.glNormalPointer(5126, 0, this.normalOffset);
        gl.glTexCoordPointer(2, 5126, 0, this.texcoordOffset);
        gl.glVertexPointer(3, 5126, 0, this.vertexOffset);
        gl.glBindBuffer(34963, this.indexBufferId);
        gl.glDrawElements(4, this.indexBufferSize, 5125, 0L);
    }

    private void init() {
        this.nrOfVertices = (this.numStacks + 1) * (this.numSlices + 1);
        this.nrOfTris = this.numStacks * this.numSlices * 2;
        this.dataBufferSize = 3 * this.nrOfVertices;
        this.texCoordBufferSize = 2 * this.nrOfVertices;
        this.indexBufferSize = 3 * this.nrOfTris;
        this.dataByteBufferSize = 4 * this.dataBufferSize;
        this.texCoordByteBufferSize = 4 * this.texCoordBufferSize;
        this.indexByteBufferSize = 4 * this.indexBufferSize;
        this.glArrayBufferSize = this.dataByteBufferSize + this.dataByteBufferSize + this.texCoordByteBufferSize;
        this.vertexData = new float[this.dataBufferSize];
        this.normalData = new float[this.dataBufferSize];
        this.texCoordData = new float[this.texCoordBufferSize];
        this.indexData = new int[this.indexBufferSize];
        this.vertexBuffer = BufferUtil.newFloatBuffer((int)this.dataBufferSize);
        this.normalBuffer = BufferUtil.newFloatBuffer((int)this.dataBufferSize);
        this.texCoordBuffer = BufferUtil.newFloatBuffer((int)this.texCoordBufferSize);
        this.indexBuffer = BufferUtil.newIntBuffer((int)this.indexBufferSize);
        this.vertexOffset = 0;
        this.normalOffset = this.vertexOffset + this.dataByteBufferSize;
        this.texcoordOffset = this.normalOffset + this.dataByteBufferSize;
        double dtheta = Math.PI / (double)this.numStacks;
        double dphi = Math.PI * 2 / (double)this.numSlices;
        double ds = 1.0 / (double)this.numSlices;
        double dt = 1.0 / (double)this.numStacks;
        int vc = 0;
        for (int i = 0; i <= this.numStacks; ++i) {
            float ctheta;
            float stheta;
            if (i == 0) {
                stheta = 0.0f;
                ctheta = -1.0f;
            } else if (i == this.numStacks) {
                stheta = 0.0f;
                ctheta = 1.0f;
            } else {
                double theta = Math.PI - (double)i * dtheta;
                stheta = (float)Math.sin(theta);
                ctheta = (float)Math.cos(theta);
            }
            float t = (float)((double)i * dt);
            for (int j = 0; j <= this.numSlices; ++j) {
                float cphi;
                float sphi;
                if (j == 0 || j == this.numSlices) {
                    sphi = 0.0f;
                    cphi = 1.0f;
                } else {
                    double phi = (double)j * dphi;
                    sphi = (float)Math.sin(phi);
                    cphi = (float)Math.cos(phi);
                }
                float x = -sphi * stheta;
                float y = ctheta;
                float z = -cphi * stheta;
                float s = (float)((double)j * ds);
                this.vertexData[3 * vc] = this.radius * x;
                this.vertexData[3 * vc + 1] = this.radius * y;
                this.vertexData[3 * vc + 2] = this.radius * z;
                this.normalData[3 * vc] = x;
                this.normalData[3 * vc + 1] = y;
                this.normalData[3 * vc + 2] = z;
                this.texCoordData[2 * vc] = s;
                this.texCoordData[2 * vc + 1] = t;
                ++vc;
            }
        }
        int tc = 0;
        for (int i = 0; i < this.numStacks; ++i) {
            for (int j = 0; j < this.numSlices; ++j) {
                int lowerleft = i * (this.numSlices + 1) + j;
                int lowerright = lowerleft + 1;
                int upperleft = lowerleft + this.numSlices + 1;
                int upperright = upperleft + 1;
                this.indexData[3 * tc] = lowerleft;
                this.indexData[3 * tc + 1] = lowerright;
                this.indexData[3 * tc + 2] = upperleft;
                this.indexData[3 * ++tc] = upperleft;
                this.indexData[3 * tc + 1] = lowerright;
                this.indexData[3 * tc + 2] = upperright;
                ++tc;
            }
        }
        this.vertexBuffer.put(this.vertexData);
        this.normalBuffer.put(this.normalData);
        this.texCoordBuffer.put(this.texCoordData);
        this.indexBuffer.put(this.indexData);
    }
}

