/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.geometry;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;

public class DiscGeometry
implements GLRenderObject {
    private float radius1 = 5.0f;
    private float radius2 = 2.0f;
    private float radius3 = 2.0f;
    private int numSlices = 32;
    private int numStacks = 16;
    private float drho;
    private float dtheta;
    private float ds;
    private float dt;
    int sphereList;

    public DiscGeometry(float radius1, float radius2, float radius3, int numSlices, int numStacks) {
        this.radius1 = radius1;
        this.radius2 = radius2;
        this.radius3 = radius3;
        this.numSlices = numSlices;
        this.numStacks = numStacks;
        this.drho = (float)Math.PI / (float)numStacks;
        this.dtheta = (float)Math.PI * 2 / (float)numSlices;
        this.ds = 1.0f / (float)numSlices;
        this.dt = 1.0f / (float)numStacks;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.sphereList = gl.glGenLists(1);
        gl.glNewList(this.sphereList, 4864);
        this.render(gl);
        gl.glEndList();
    }

    @Override
    public void glRender(GLRenderContext gl) {
        this.render(gl);
    }

    private void render(GLRenderContext gl) {
        float t = 1.0f;
        float s = 0.0f;
        for (int i = 0; i < this.numStacks; ++i) {
            float rho = (float)i * this.drho;
            float srho = (float)Math.sin(rho);
            float crho = (float)Math.cos(rho);
            float srhodrho = (float)Math.sin(rho + this.drho);
            float crhodrho = (float)Math.cos(rho + this.drho);
            gl.glBegin(5);
            s = 0.0f;
            for (int j = 0; j <= this.numSlices; ++j) {
                float theta = j == this.numSlices ? 0.0f : (float)j * this.dtheta;
                float stheta = (float)(-Math.sin(theta));
                float ctheta = (float)Math.cos(theta);
                float x = stheta * srho;
                float y = ctheta * srho;
                float z = crho;
                gl.glTexCoord2f(s, t);
                gl.glNormal3f(x, y, z);
                gl.glVertex3f(x * this.radius1, y * this.radius2, z * this.radius3);
                x = stheta * srhodrho;
                y = ctheta * srhodrho;
                z = crhodrho;
                gl.glTexCoord2f(s, t - this.dt);
                s += this.ds;
                gl.glNormal3f(x, y, z);
                gl.glVertex3f(x * this.radius1, y * this.radius2, z * this.radius3);
            }
            gl.glEnd();
            t -= this.dt;
        }
    }
}

