/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.geometry;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;

public class CapsuleGeometry
implements GLRenderObject {
    public static final int NUM_SLICES = 8;
    public static final int NUM_STACKS = 12;
    private float cylinderHeight;
    private float height;
    private float radius;
    private int numSlices = 8;
    private int numStacks = 12;
    private float drho;
    private float dtheta;
    private float ds;
    private float dt;
    private int sphereList;

    public CapsuleGeometry(float r, float h, int slices, int stacks) {
        this.numSlices = 2 * slices;
        this.numStacks = 2 * stacks;
        this.height = h;
        this.radius = r;
        this.cylinderHeight = this.height;
        this.drho = (float)Math.PI / (float)this.numStacks;
        this.dtheta = (float)Math.PI * 2 / (float)this.numSlices;
        this.ds = 1.0f / (float)this.numSlices;
        this.dt = 1.0f / (float)this.numStacks;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.sphereList = gl.glGenLists(1);
        gl.glNewList(this.sphereList, 4864);
        this.render(gl);
        gl.glEndList();
    }

    @Override
    public void glRender(GLRenderContext gl) {
        this.render(gl);
    }

    private void render(GLRenderContext gl) {
        float z;
        float y;
        float x;
        float ctheta;
        float stheta;
        float theta;
        int j;
        float crhodrho;
        float srhodrho;
        float crho;
        float srho;
        float rho;
        int i;
        float t = 1.0f;
        float s = 0.0f;
        for (i = 0; i < this.numStacks; ++i) {
            rho = (float)i * this.drho;
            srho = (float)Math.sin(rho);
            crho = (float)Math.cos(rho);
            srhodrho = (float)Math.sin(rho + this.drho);
            crhodrho = (float)Math.cos(rho + this.drho);
            gl.glBegin(5);
            s = 0.0f;
            for (j = 0; j <= this.numSlices / 2; ++j) {
                theta = j == this.numSlices ? 0.0f : (float)j * this.dtheta;
                stheta = (float)(-Math.sin(theta));
                ctheta = (float)Math.cos(theta);
                x = ctheta * srho;
                y = stheta * srho;
                z = crho;
                gl.glTexCoord2f(s, t);
                gl.glNormal3f(x, y - this.cylinderHeight / 2.0f, z);
                gl.glVertex3f(x * this.radius, y * this.radius - this.cylinderHeight / 2.0f, z * this.radius);
                x = ctheta * srhodrho;
                y = stheta * srhodrho;
                z = crhodrho;
                gl.glTexCoord2f(s, t - this.dt);
                s += this.ds;
                gl.glNormal3f(x, y - this.cylinderHeight / 2.0f, z);
                gl.glVertex3f(x * this.radius, y * this.radius - this.cylinderHeight / 2.0f, z * this.radius);
            }
            gl.glEnd();
            t -= this.dt;
        }
        gl.glBegin(5);
        for (i = 0; i <= 2 * this.numStacks; ++i) {
            rho = (float)i * this.drho;
            float x2 = (float)Math.sin(rho);
            float y2 = -this.cylinderHeight / 2.0f;
            float z2 = (float)Math.cos(rho);
            gl.glNormal3f(x2, y2, z2);
            gl.glVertex3f(x2 * this.radius, y2, z2 * this.radius);
            y2 = this.cylinderHeight / 2.0f;
            gl.glNormal3f(x2, y2, z2);
            gl.glVertex3f(x2 * this.radius, y2, z2 * this.radius);
        }
        gl.glEnd();
        for (i = 0; i < this.numStacks; ++i) {
            rho = (float)i * this.drho;
            srho = (float)Math.sin(rho);
            crho = (float)Math.cos(rho);
            srhodrho = (float)Math.sin(rho + this.drho);
            crhodrho = (float)Math.cos(rho + this.drho);
            gl.glBegin(5);
            s = 0.0f;
            for (j = this.numSlices / 2; j <= this.numSlices; ++j) {
                theta = j == this.numSlices ? 0.0f : (float)j * this.dtheta;
                stheta = (float)(-Math.sin(theta));
                ctheta = (float)Math.cos(theta);
                x = ctheta * srho;
                y = stheta * srho;
                z = crho;
                gl.glTexCoord2f(s, t);
                gl.glNormal3f(x, y + this.cylinderHeight / 2.0f, z);
                gl.glVertex3f(x * this.radius, y * this.radius + this.cylinderHeight / 2.0f, z * this.radius);
                x = ctheta * srhodrho;
                y = stheta * srhodrho;
                z = crhodrho;
                gl.glTexCoord2f(s, t - this.dt);
                s += this.ds;
                gl.glNormal3f(x, y + this.cylinderHeight / 2.0f, z);
                gl.glVertex3f(x * this.radius, y * this.radius + this.cylinderHeight / 2.0f, z * this.radius);
            }
            gl.glEnd();
            t -= this.dt;
        }
    }
}

