/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLUtil {
    private static Logger logger = LoggerFactory.getLogger((String)GLUtil.class.getName());
    public static final int MAXERRORS = 100;

    public static String getErrorMessage(GLBinding glc) {
        int err = glc.glGetError();
        String errmsg = glc.gluErrorString(err);
        return errmsg;
    }

    public static int reportGLErrors(GLBinding glc) {
        int errcount;
        int glerror = glc.glGetError();
        for (errcount = 0; glerror != 0 && errcount < 100; ++errcount) {
            String errmsg = glc.gluErrorString(glerror);
            logger.warn("OpenGL Error: {}", (Object)errmsg);
            glerror = glc.glGetError();
        }
        return errcount;
    }
}

