/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLTexture;
import hmi.graphics.opengl.GLTextureLoader;
import hmi.util.Console;
import hmi.util.ResourcePool;
import hmi.util.Resources;
import java.io.IOException;

public class GLTextures {
    private static ResourcePool pool = new ResourcePool();
    public static final String DEFAULT_TEXTURE_RESOURCE_DIR = "textures";

    public static void addTextureDirectory(String dir) {
        pool.addResourceDirectory(dir);
    }

    public static GLTexture getGLTexture(String resourceName) {
        return GLTextures.getGLTexture(resourceName, true, true);
    }

    public static GLTexture getGLTexture(String resourceName, boolean flip, boolean rescale) {
        try {
            return (GLTexture)pool.getResource(resourceName, new Object[]{flip, rescale});
        }
        catch (IOException e) {
            Console.println((String)("GLTextures: " + e));
            return null;
        }
    }

    static {
        ResourcePool.ResourceLoader loader = new ResourcePool.ResourceLoader(){

            public Object loadResource(Resources res, String resourceName, Object[] par) throws IOException {
                boolean flip = (Boolean)par[0];
                boolean rescale = (Boolean)par[1];
                return GLTextureLoader.readFromResourceFile(res, resourceName, rescale, flip);
            }
        };
        pool.setResourceLoader(loader);
        pool.addResourceDirectory(DEFAULT_TEXTURE_RESOURCE_DIR);
    }
}

