/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLTexture;
import hmi.util.Console;
import hmi.util.ResourcePool;
import hmi.util.Resources;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;

public class GLTextureLoader {
    private static ResourcePool pool = new ResourcePool();
    public static final String DEFAULT_TEXTURE_RESOURCE_DIR = "textures";
    private static String currentFileName;
    static ComponentColorModel rgbaModel;
    static ComponentColorModel rgbModel;

    public static void addTextureDirectory(String dir) {
        pool.addResourceDirectory(dir);
    }

    public static GLTexture getGLTexture(String resourceName) {
        return GLTextureLoader.getGLTexture(0, resourceName, true, true);
    }

    public static GLTexture getGLTexture(int texUnit, String resourceName) {
        return GLTextureLoader.getGLTexture(texUnit, resourceName, true, true);
    }

    public static GLTexture getGLTexture(int texUnit, String resourceName, boolean flip, boolean rescale) {
        try {
            GLTexture glt = (GLTexture)pool.getResource(resourceName, new Object[]{flip, rescale});
            if (glt != null) {
                glt.setTextureUnit(texUnit);
            }
            return glt;
        }
        catch (IOException e) {
            Console.println((String)("GLTextures: " + e));
            return null;
        }
    }

    public static GLTexture readFromFile(String fileName, boolean rescale, boolean flip) throws IOException {
        currentFileName = fileName;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));
        return GLTextureLoader.readFromStream(is, rescale, flip, fileName);
    }

    public static GLTexture readFromFile(File file, boolean rescale, boolean flip) throws IOException {
        currentFileName = file.getName();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        return GLTextureLoader.readFromStream(is, rescale, flip, currentFileName);
    }

    public static GLTexture readFromResourceFile(Resources resources, String resourceName, boolean rescale, boolean flip) throws IOException {
        currentFileName = resourceName;
        BufferedInputStream is = resources.getInputStream(resourceName);
        return GLTextureLoader.readFromStream(is, rescale, flip, resourceName);
    }

    public static GLTexture readFromStream(InputStream is, boolean rescale, boolean flip, String imageFile) throws IOException {
        if (is == null) {
            return null;
        }
        BufferedImage image = ImageIO.read(is);
        GLTexture texture = GLTextureLoader.convertBufferedImage(image, rescale, flip, imageFile);
        is.close();
        image.flush();
        currentFileName = null;
        return texture;
    }

    public static void flipImageVertically(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        Object scanline1 = null;
        Object scanline2 = null;
        for (int i = 0; i < image.getHeight() / 2; ++i) {
            scanline1 = raster.getDataElements(0, i, image.getWidth(), 1, scanline1);
            scanline2 = raster.getDataElements(0, image.getHeight() - i - 1, image.getWidth(), 1, scanline2);
            raster.setDataElements(0, i, image.getWidth(), 1, scanline2);
            raster.setDataElements(0, image.getHeight() - i - 1, image.getWidth(), 1, scanline1);
        }
    }

    private static GLTexture convertBufferedImage(BufferedImage image, boolean rescale, boolean flip, String imageFile) {
        int texHeight;
        int texWidth;
        byte[] data = null;
        if (flip) {
            GLTextureLoader.flipImageVertically(image);
        }
        int bwidth = image.getWidth();
        int bheight = image.getHeight();
        boolean hasAlpha = image.getColorModel().hasAlpha();
        int type = 0;
        int format = 0;
        boolean conversionNeeded = false;
        if (rescale) {
            texWidth = GLTextureLoader.getPowerOfTwo(bwidth);
            texHeight = GLTextureLoader.getPowerOfTwo(bheight);
            String fn = currentFileName == null ? "<?>" : currentFileName;
            boolean bl = conversionNeeded = texWidth != bwidth || texHeight != bheight;
            if (conversionNeeded) {
                Console.println((String)("Texture " + fn + " original size: " + bwidth + "X" + bheight + "  resized: " + texWidth + "X" + texHeight));
            }
        } else {
            texWidth = bwidth;
            texHeight = bheight;
            conversionNeeded = false;
        }
        switch (image.getType()) {
            case 5: {
                format = 32992;
                type = 5121;
                break;
            }
            case 0: {
                ColorModel cm = image.getColorModel();
                if (cm.equals(rgbModel)) {
                    format = 6407;
                    type = 5121;
                    break;
                }
                if (cm.equals(rgbaModel)) {
                    format = 6408;
                    type = 5121;
                    break;
                }
                Console.println((String)"custom color model");
                conversionNeeded = true;
                break;
            }
            default: {
                conversionNeeded = true;
            }
        }
        if (conversionNeeded) {
            try {
                WritableRaster raster;
                BufferedImage texImage = null;
                if (image.getColorModel().hasAlpha()) {
                    raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 4, null);
                    texImage = new BufferedImage(rgbaModel, raster, false, null);
                    format = 6408;
                    type = 5121;
                } else {
                    raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 3, null);
                    texImage = new BufferedImage(rgbModel, raster, false, null);
                    format = 6407;
                    type = 5121;
                }
                ((Graphics2D)texImage.getGraphics()).drawImage(image, new AffineTransformOp(AffineTransform.getScaleInstance((double)texWidth / (double)bwidth, (double)texHeight / (double)bheight), 2), 0, 0);
                data = ((DataBufferByte)texImage.getRaster().getDataBuffer()).getData();
                texImage.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to convert texture data " + e);
            }
        } else {
            data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        }
        ByteBuffer imageBuffer = ByteBuffer.allocateDirect(data.length);
        imageBuffer.order(ByteOrder.nativeOrder());
        imageBuffer.put(data, 0, data.length);
        imageBuffer.rewind();
        GLTexture texture = new GLTexture(texWidth, texHeight, format, type, hasAlpha, imageBuffer, imageFile);
        return texture;
    }

    private static int getPowerOfTwo(int size) {
        int powerOfTwo;
        for (powerOfTwo = 2; powerOfTwo < size; powerOfTwo *= 2) {
        }
        return powerOfTwo;
    }

    static {
        ResourcePool.ResourceLoader loader = new ResourcePool.ResourceLoader(){

            public Object loadResource(Resources res, String resourceName, Object[] par) throws IOException {
                boolean flip = (Boolean)par[0];
                boolean rescale = (Boolean)par[1];
                return GLTextureLoader.readFromResourceFile(res, resourceName, rescale, flip);
            }
        };
        pool.setResourceLoader(loader);
        pool.addResourceDirectory(DEFAULT_TEXTURE_RESOURCE_DIR);
        currentFileName = null;
        rgbaModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
        rgbModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);
    }
}

