/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.math.Mat4f;
import hmi.util.Console;

public class GLShape
implements GLRenderObject {
    protected GLRenderList glStateList = new GLRenderList();
    protected GLRenderList glGeometryList = new GLRenderList();
    private String name;
    protected float[] transformMatrix;
    private boolean visible = true;
    public static final int STATE = 1;
    public static final int GEOM = 2;
    float[] mv = new float[16];

    public GLShape() {
        this.transformMatrix = Mat4f.getIdentity();
    }

    public GLShape(String name) {
        this.name = name;
        this.transformMatrix = Mat4f.getIdentity();
    }

    public String getId() {
        return this.name;
    }

    public String getInfo() {
        return "GLShape \"" + this.name + "\"  state/geoms=" + this.glStateList.size() + "/" + this.glGeometryList.size();
    }

    public GLRenderList getGeometryList() {
        return this.glGeometryList;
    }

    public GLRenderList getStateList() {
        return this.glStateList;
    }

    public void hide() {
        this.visible = false;
    }

    public void show() {
        this.visible = true;
    }

    public void printInfo(int mod) {
        int i;
        Console.println((String)("GLShape \"" + this.name + "\"  state/geoms=" + this.glStateList.size() + "/" + this.glGeometryList.size()));
        if ((mod & 1) != 0) {
            for (i = 0; i < this.glStateList.size(); ++i) {
                GLRenderObject glo = this.glStateList.get(i);
                Console.println((String)("State: " + glo));
            }
        }
        if ((mod & 2) != 0) {
            for (i = 0; i < this.glGeometryList.size(); ++i) {
                GLRenderObject glgeom = this.glGeometryList.get(i);
                Console.println((String)("Geom: " + glgeom));
            }
        }
    }

    public void addGLGeometry(GLRenderObject glGeometry) {
        this.glGeometryList.add(glGeometry);
    }

    public void addGLState(GLRenderObject glState) {
        this.glStateList.add(glState);
    }

    public void linkToTransformMatrix(float[] transformMatrix) {
        this.transformMatrix = transformMatrix;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.glStateList.glInit(gl);
        this.glGeometryList.glInit(gl);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        if (!this.visible) {
            return;
        }
        gl.glPushMatrix();
        gl.glMultTransposeMatrixf(this.transformMatrix);
        if (gl.getPass() != 1) {
            this.glStateList.glRender(gl);
        }
        this.glGeometryList.glRender(gl);
        gl.glPopMatrix();
    }

    public String toString() {
        return "<GLShape.glStateList=\n" + this.glStateList.toString() + "\n GLshape.glGeometryList=\n" + this.glGeometryList.toString() + ">";
    }
}

