/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.util.BufferUtil;
import hmi.util.Console;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GLShaderProgram
implements GLRenderObject {
    private String vstext;
    private String fstext;
    private int shaderId = 0;
    private String shaderName;
    static Pattern uniformLinePattern = Pattern.compile("^\\s*uniform\\s+(\\w.*);", 8);
    static Pattern declPattern = Pattern.compile("(\\w+)\\s*(.*)");
    static Pattern varPattern = Pattern.compile("(\\w+)([\\[\\]\\d]*)");

    public GLShaderProgram() {
    }

    public GLShaderProgram(String shaderName, String vstext, String fstext) {
        this.vstext = vstext;
        this.fstext = fstext;
        this.shaderName = shaderName;
    }

    public int getProgramId() {
        return this.shaderId;
    }

    public int[] getUniformLocations(GLRenderContext gl, String ... uniformNames) {
        if (uniformNames == null) {
            return new int[0];
        }
        int[] uLocation = new int[uniformNames.length];
        for (int i = 0; i < uLocation.length; ++i) {
            uLocation[i] = gl.glGetUniformLocation(this.shaderId, uniformNames[i]);
        }
        return uLocation;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        if (this.shaderId <= 0) {
            this.shaderId = this.createShaderProgram(gl, this.vstext, this.fstext);
        }
    }

    @Override
    public final void glRender(GLRenderContext gl) {
        gl.glUseProgram(this.shaderId);
    }

    private int createShaderProgram(GLRenderContext gl, String vertexShaderText, String fragmentShaderText) {
        int program = gl.glCreateProgram();
        if (vertexShaderText != null) {
            int vertexShader = this.compileShader(gl, vertexShaderText, 35633);
            if (vertexShader < 0) {
                return -1;
            }
            gl.glAttachShader(program, vertexShader);
        }
        if (fragmentShaderText != null) {
            int fragmentShader = this.compileShader(gl, fragmentShaderText, 35632);
            if (fragmentShader < 0) {
                return -1;
            }
            gl.glAttachShader(program, fragmentShader);
        }
        gl.glLinkProgram(program);
        IntBuffer linkStatus = BufferUtil.directIntBuffer(1);
        gl.glGetProgramiv(program, 35714, linkStatus);
        if (linkStatus.get(0) != 1) {
            Console.println((String)("Shader \"" + this.shaderName + "\" Linking problem: "));
            IntBuffer infologlength = BufferUtil.directIntBuffer(1);
            gl.glGetShaderiv(program, 35716, infologlength);
            int loglen = infologlength.get(0);
            ByteBuffer infolog = BufferUtil.directByteBuffer(loglen);
            IntBuffer lenBuf = BufferUtil.directIntBuffer(1);
            gl.glGetProgramInfoLog(program, loglen, lenBuf, infolog);
            String logstr = BufferUtil.toString(infolog);
            Console.println((String)logstr);
            return -1;
        }
        return program;
    }

    private int compileShader(GLRenderContext gl, String shaderText, int shaderType) {
        int shader = gl.glCreateShader(shaderType);
        gl.glShaderSource(shader, 1, new String[]{shaderText}, null);
        gl.glCompileShader(shader);
        IntBuffer compileStatus = BufferUtil.directIntBuffer(1);
        gl.glGetShaderiv(shader, 35713, compileStatus);
        if (compileStatus.get(0) != 1) {
            Console.println((String)("GLSL Shader \"" + this.shaderName + "\" Compilation problem, status:  " + compileStatus.get(0)));
            IntBuffer infologlength = BufferUtil.directIntBuffer(1);
            gl.glGetShaderiv(shader, 35716, infologlength);
            int loglen = infologlength.get(0);
            ByteBuffer infolog = BufferUtil.directByteBuffer(loglen);
            gl.glGetShaderInfoLog(shader, loglen, null, infolog);
            String logstr = BufferUtil.toString(infolog);
            Console.println((String)("Compilation Problem: " + logstr));
            return -1;
        }
        return shader;
    }

    public int getShaderUniforms(List<String> types, List<String> names) {
        List<String> uniformLines = GLShaderProgram.getUniformLines(this.vstext + this.fstext);
        return GLShaderProgram.getUniforms(uniformLines, types, names);
    }

    public static List<String> getUniformLines(String shader) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = uniformLinePattern.matcher(shader);
        boolean uniformRecognized = m.find();
        while (uniformRecognized) {
            String decls = m.group(1);
            result.add(decls);
            uniformRecognized = m.find();
        }
        return result;
    }

    public static int getUniforms(List<String> decls, List<String> types, List<String> names) {
        int n_added = 0;
        for (String decl : decls) {
            Matcher mdecl = declPattern.matcher(decl);
            if (!mdecl.matches()) {
                Console.println((String)("GLShaderProgram -- unrecognized uniform declaration: " + decl));
                continue;
            }
            String type = mdecl.group(1);
            String vars = mdecl.group(2);
            Matcher mvar = varPattern.matcher(vars);
            boolean varRecognized = mvar.find();
            while (varRecognized) {
                String var = mvar.group(1);
                String arrayDec = mvar.group(2);
                types.add(type + arrayDec);
                names.add(var);
                ++n_added;
                varRecognized = mvar.find();
            }
        }
        return n_added;
    }
}

