/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShaderProgram;
import hmi.graphics.opengl.GLShaderProgramLoader;
import hmi.util.Console;
import java.util.ArrayList;

public class GLShader
implements GLRenderObject {
    private GLShaderProgram prog;
    private String shaderProgName;
    private int progId = -1;
    private int nrOfUniforms;
    private String[] uName;
    private int[] uType;
    private int[] uBaseType;
    private int[] uSize;
    private int[] uLocation;
    private int[] uOffset;
    private int[] intValue;
    private float[] floatValue;
    public static final int I = 0;
    public static final int F = 1;
    public static final int IV = 2;
    public static final int FV = 3;
    public static final int U1I = 1;
    public static final int U2I = 2;
    public static final int U3I = 3;
    public static final int U4I = 4;
    public static final int U1F = 5;
    public static final int U2F = 6;
    public static final int U3F = 7;
    public static final int U4F = 8;
    public static final int U1B = 9;
    public static final int U2B = 10;
    public static final int U3B = 11;
    public static final int U4B = 12;
    ArrayList<String> declaredTypes;

    public GLShader(String shaderProg, String ... uniformNamesAndTypes) {
        this.shaderProgName = shaderProg;
        this.prog = GLShaderProgramLoader.getGLShaderProgram(shaderProg);
        if (this.prog == null) {
            Console.println((String)("GLShader: Could not find/load shader program for shader " + shaderProg));
            return;
        }
        ArrayList<String> declared = new ArrayList<String>(uniformNamesAndTypes.length);
        for (int i = 0; i < uniformNamesAndTypes.length; ++i) {
            declared.add(uniformNamesAndTypes[i]);
        }
        ArrayList<String> declaredNames = new ArrayList<String>();
        this.declaredTypes = new ArrayList();
        GLShaderProgram.getUniforms(declared, this.declaredTypes, declaredNames);
        ArrayList<String> shaderNames = new ArrayList<String>();
        ArrayList<String> shaderTypes = new ArrayList<String>();
        this.prog.getShaderUniforms(shaderTypes, shaderNames);
        int nru = declaredNames.size();
        int nrup = shaderNames.size();
        if (nru == 0) {
            declaredNames = shaderNames;
            this.declaredTypes = shaderTypes;
            nru = nrup;
        } else {
            for (int i = 0; i < nru; ++i) {
                String nm = declaredNames.get(i);
                boolean found = false;
                for (int j = 0; j < nrup; ++j) {
                    if (!shaderNames.get(j).equals(nm)) continue;
                    found = true;
                    if (shaderTypes.get(j).equals(this.declaredTypes.get(i))) continue;
                    Console.println((String)("GLShader warning: uniform\"" + nm + "\" within shader \"" + shaderProg + "\" has ambiguous types: " + this.declaredTypes.get(i) + " versus " + shaderTypes.get(j) + " (in shader)"));
                }
                if (found) continue;
                Console.println((String)("GLShader warning: uniform \"" + nm + "\" does not occur within shader \"" + shaderProg + "\""));
            }
        }
        String[] uniformNames = new String[nru];
        int[] uniformTypes = new int[nru];
        for (int i = 0; i < nru; ++i) {
            uniformNames[i] = declaredNames.get(i);
            String stp = this.declaredTypes.get(i);
            int tp = 0;
            if (stp.equals("int")) {
                tp = 1;
            } else if (stp.equals("float")) {
                tp = 5;
            } else if (stp.equals("bool")) {
                tp = 9;
            } else if (stp.equals("uint")) {
                tp = 1;
            } else if (stp.equals("ivec2")) {
                tp = 2;
            } else if (stp.equals("ivec3")) {
                tp = 3;
            } else if (stp.equals("ivec4")) {
                tp = 4;
            } else if (stp.equals("vec2")) {
                tp = 6;
            } else if (stp.equals("vec3")) {
                tp = 7;
            } else if (stp.equals("vec4")) {
                tp = 8;
            } else if (stp.equals("sampler1D")) {
                tp = 1;
            } else if (stp.equals("sampler2D")) {
                tp = 1;
            } else if (stp.equals("sampler3D")) {
                tp = 1;
            } else if (stp.equals("samplerCube")) {
                tp = 1;
            }
            uniformTypes[i] = tp;
        }
        this.init(uniformNames, uniformTypes);
    }

    private void init(String[] uniformNames, int[] uniformTypes) {
        int n = this.nrOfUniforms = uniformNames == null ? 0 : uniformNames.length;
        if (this.nrOfUniforms == 0) {
            // empty if block
        }
        this.uName = uniformNames;
        this.uType = uniformTypes;
        this.uOffset = new int[this.nrOfUniforms];
        this.uSize = new int[this.nrOfUniforms];
        this.uBaseType = new int[this.nrOfUniforms];
        int ioc = 0;
        int foc = 0;
        block10: for (int i = 0; i < this.nrOfUniforms; ++i) {
            int uniformType = this.uType[i];
            switch (uniformType) {
                case 1: {
                    this.uOffset[i] = ioc++;
                    this.uBaseType[i] = 0;
                    this.uSize[i] = 1;
                    continue block10;
                }
                case 2: {
                    this.uOffset[i] = ioc;
                    ioc += 2;
                    this.uBaseType[i] = 0;
                    this.uSize[i] = 2;
                    continue block10;
                }
                case 3: {
                    this.uOffset[i] = ioc;
                    ioc += 3;
                    this.uBaseType[i] = 0;
                    this.uSize[i] = 3;
                    continue block10;
                }
                case 4: {
                    this.uOffset[i] = ioc;
                    ioc += 4;
                    this.uBaseType[i] = 0;
                    this.uSize[i] = 4;
                    continue block10;
                }
                case 5: {
                    this.uOffset[i] = foc++;
                    this.uBaseType[i] = 1;
                    this.uSize[i] = 1;
                    continue block10;
                }
                case 6: {
                    this.uOffset[i] = foc;
                    foc += 2;
                    this.uBaseType[i] = 1;
                    this.uSize[i] = 2;
                    continue block10;
                }
                case 7: {
                    this.uOffset[i] = foc;
                    foc += 3;
                    this.uBaseType[i] = 1;
                    this.uSize[i] = 3;
                    continue block10;
                }
                case 8: {
                    this.uOffset[i] = foc;
                    foc += 4;
                    this.uBaseType[i] = 1;
                    this.uSize[i] = 4;
                }
            }
        }
        this.intValue = new int[ioc];
        this.floatValue = new float[foc];
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("shader ");
        buf.append(this.shaderProgName);
        buf.append("(");
        for (int i = 0; i < this.nrOfUniforms; ++i) {
            buf.append(this.declaredTypes.get(i));
            buf.append(' ');
            buf.append(this.uName[i]);
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    public void setValue(String uniformName, Object ... vals) {
        for (int i = 0; i < this.nrOfUniforms; ++i) {
            if (!this.uName[i].equals(uniformName)) continue;
            int offset = this.uOffset[i];
            int size = this.uSize[i];
            switch (this.uBaseType[i]) {
                case 0: {
                    for (int j = 0; j < size; ++j) {
                        this.intValue[offset + j] = (Integer)vals[j];
                    }
                    break;
                }
                case 1: {
                    for (int j = 0; j < size; ++j) {
                        this.floatValue[offset + j] = ((Float)vals[j]).floatValue();
                    }
                    break;
                }
            }
            return;
        }
    }

    public void setValues(Object ... vals) {
        int voffset = 0;
        for (int i = 0; i < this.nrOfUniforms; ++i) {
            int offset = this.uOffset[i];
            int size = this.uSize[i];
            switch (this.uBaseType[i]) {
                case 0: {
                    int j;
                    for (j = 0; j < size; ++j) {
                        this.intValue[offset + j] = (Integer)vals[voffset + j];
                    }
                    break;
                }
                case 1: {
                    int j;
                    for (j = 0; j < size; ++j) {
                        this.floatValue[offset + j] = ((Float)vals[voffset + j]).floatValue();
                    }
                    break;
                }
            }
            voffset += size;
        }
    }

    public void setValues(int[] intVals, float[] floatVals) {
        int i;
        if (intVals != null) {
            for (i = 0; i < intVals.length; ++i) {
                this.intValue[i] = intVals[i];
            }
        }
        if (floatVals != null) {
            for (i = 0; i < floatVals.length; ++i) {
                this.floatValue[i] = floatVals[i];
            }
        }
    }

    private void glSetUniformValue(GLRenderContext gl, int i) {
        switch (this.uType[i]) {
            case 1: {
                gl.glUniform1i(this.uLocation[i], this.intValue[this.uOffset[i]]);
                break;
            }
            case 2: {
                gl.glUniform2i(this.uLocation[i], this.intValue[this.uOffset[i]], this.intValue[this.uOffset[i] + 1]);
                break;
            }
            case 3: {
                gl.glUniform3i(this.uLocation[i], this.intValue[this.uOffset[i]], this.intValue[this.uOffset[i] + 1], this.intValue[this.uOffset[i] + 2]);
                break;
            }
            case 4: {
                gl.glUniform4i(this.uLocation[i], this.intValue[this.uOffset[i]], this.intValue[this.uOffset[i] + 1], this.intValue[this.uOffset[i] + 2], this.intValue[this.uOffset[i] + 3]);
                break;
            }
            case 5: {
                gl.glUniform1f(this.uLocation[i], this.floatValue[this.uOffset[i]]);
                break;
            }
            case 6: {
                gl.glUniform2f(this.uLocation[i], this.floatValue[this.uOffset[i]], this.floatValue[this.uOffset[i] + 1]);
                break;
            }
            case 7: {
                gl.glUniform3f(this.uLocation[i], this.floatValue[this.uOffset[i]], this.floatValue[this.uOffset[i] + 1], this.floatValue[this.uOffset[i] + 2]);
                break;
            }
            case 8: {
                gl.glUniform4f(this.uLocation[i], this.floatValue[this.uOffset[i]], this.floatValue[this.uOffset[i] + 1], this.floatValue[this.uOffset[i] + 2], this.floatValue[this.uOffset[i] + 3]);
                break;
            }
        }
    }

    @Override
    public void glInit(GLRenderContext gl) {
        if (this.prog == null) {
            this.progId = 0;
            return;
        }
        this.prog.glInit(gl);
        this.progId = this.prog.getProgramId();
        this.uLocation = this.prog.getUniformLocations(gl, this.uName);
        gl.glUseProgram(this.progId);
        for (int i = 0; i < this.nrOfUniforms; ++i) {
            this.glSetUniformValue(gl, i);
        }
    }

    @Override
    public final void glRender(GLRenderContext gl) {
        gl.glUseProgram(this.progId);
        for (int i = 0; i < this.nrOfUniforms; ++i) {
            this.glSetUniformValue(gl, i);
        }
    }
}

