/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLRenderContext;
import hmi.util.Console;
import hmi.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;

public class GLSL {
    public static int compileShader(GLRenderContext gl, String[] shaderText, int shaderType) {
        int shader = gl.glCreateShader(shaderType);
        gl.glShaderSource(shader, shaderText.length, shaderText, null);
        gl.glCompileShader(shader);
        int[] compileStatus = new int[1];
        gl.glGetShaderiv(shader, 35713, compileStatus);
        if (compileStatus[0] != 1) {
            Console.println((String)"GLSL Shader Compilation problem: ");
            int[] infologlength = new int[1];
            gl.glGetShaderiv(shader, 35716, infologlength);
            int infolen = infologlength[0];
            byte[] infolog = new byte[infolen];
            gl.glGetShaderInfoLog(shader, infolen, null, infolog);
            String logstr = new String(infolog);
            Console.println((String)logstr);
            return -1;
        }
        return shader;
    }

    public static int createShaderProgram(GLRenderContext gl, String vertexShaderText, String fragmentShaderText) {
        return GLSL.createShaderProgram(gl, new String[]{vertexShaderText}, new String[]{fragmentShaderText});
    }

    public static int createShaderProgram(GLRenderContext gl, String[] vertexShaderText, String[] fragmentShaderText) {
        int program = gl.glCreateProgram();
        if (vertexShaderText != null) {
            int vertexShader = GLSL.compileShader(gl, vertexShaderText, 35633);
            if (vertexShader < 0) {
                return -1;
            }
            gl.glAttachShader(program, vertexShader);
        }
        if (fragmentShaderText != null) {
            int fragmentShader = GLSL.compileShader(gl, fragmentShaderText, 35632);
            if (fragmentShader < 0) {
                return -1;
            }
            gl.glAttachShader(program, fragmentShader);
        }
        gl.glLinkProgram(program);
        int[] linkStatus = new int[1];
        gl.glGetProgramiv(program, 35714, linkStatus);
        if (linkStatus[0] != 1) {
            Console.println((String)"Shader Linking problem: ");
            int[] infologlength = new int[1];
            gl.glGetShaderiv(program, 35716, infologlength);
            int infolen = 1024;
            byte[] infolog = new byte[infolen];
            gl.glGetProgramInfoLog(program, infolen, infologlength, infolog);
            String logstr = new String(infolog);
            Console.println((String)logstr);
            return -1;
        }
        return program;
    }

    public static String loadShaderText(Resources resources, String shaderName) {
        BufferedReader br = resources.getReader(shaderName);
        if (br == null) {
            Console.println((String)("GLSL: Could not find shader file: " + shaderName + " in resources: " + resources));
            return null;
        }
        StringBuilder buf = new StringBuilder();
        try {
            String line = br.readLine();
            while (line != null) {
                buf.append(line);
                buf.append('\n');
                line = br.readLine();
            }
            return buf.toString();
        }
        catch (IOException e) {
            Console.println((String)("GLSL.loadShaderText: " + e));
            return null;
        }
    }

    public static int loadShaderProgram(GLRenderContext gl, Resources resources, String shaderProgramName) {
        String vstext = GLSL.loadShaderText(resources, shaderProgramName + ".vs");
        if (vstext == null) {
            return -1;
        }
        String fstext = GLSL.loadShaderText(resources, shaderProgramName + ".fs");
        if (fstext == null) {
            return -1;
        }
        return GLSL.createShaderProgram(gl, vstext, fstext);
    }
}

