/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;

public class GLRenderList
implements GLRenderObject {
    private static final GLRenderObject[] EMPTYLIST = new GLRenderObject[0];
    private GLRenderObject[] renderList = EMPTYLIST;
    private int arraySize = 0;
    private int size = 0;
    private static final int DEFAULTSIZE = 8;

    public GLRenderList() {
    }

    public GLRenderList(int capacity) {
        this.ensureArraySize(capacity);
    }

    private void ensureArraySize(int requestedSize) {
        if (requestedSize <= this.arraySize) {
            return;
        }
        if (this.arraySize == 0) {
            this.arraySize = 8;
        }
        while (this.arraySize < requestedSize) {
            this.arraySize *= 2;
        }
        GLRenderObject[] newRenderList = new GLRenderObject[this.arraySize];
        System.arraycopy(this.renderList, 0, newRenderList, 0, this.size);
        this.renderList = newRenderList;
    }

    public int size() {
        return this.size;
    }

    public void add(GLRenderObject ro) {
        this.ensureArraySize(this.size + 1);
        this.renderList[this.size] = ro;
        ++this.size;
    }

    public void addAll(GLRenderList rlist) {
        if (rlist == null) {
            return;
        }
        this.ensureArraySize(this.size + rlist.size);
        for (int i = 0; i < rlist.size; ++i) {
            this.renderList[this.size + i] = rlist.renderList[i];
        }
        this.size += rlist.size;
    }

    public void prepend(GLRenderObject ro) {
        this.ensureArraySize(this.size + 1);
        for (int i = this.size; i > 0; --i) {
            this.renderList[i] = this.renderList[i - 1];
        }
        this.renderList[0] = ro;
        ++this.size;
    }

    public GLRenderObject get(int i) {
        if (i < 0 || i >= this.size) {
            return null;
        }
        return this.renderList[i];
    }

    @Override
    public void glInit(GLRenderContext glc) {
        for (int i = 0; i < this.size; ++i) {
            this.renderList[i].glInit(glc);
        }
    }

    @Override
    public void glRender(GLRenderContext glc) {
        for (int i = 0; i < this.size; ++i) {
            this.renderList[i].glRender(glc);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("GLRenderList(");
        for (int i = 0; i < this.size; ++i) {
            buf.append("\n");
            buf.append(this.renderList[i].toString());
        }
        buf.append(")");
        return buf.toString();
    }
}

