/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLVertexAttribute;
import hmi.graphics.scenegraph.VertexAttribute;
import hmi.graphics.util.BufferUtil;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;

public class GLBasicMesh
implements GLRenderObject {
    private IntBuffer indexBuffer;
    private int nrOfIndices;
    private int indexByteBufferSize;
    private boolean indexBufferModified;
    protected int nrOfVertices;
    private ArrayList<GLVertexAttribute> attributeList = new ArrayList(16);
    private int vertexBufferId;
    private int indexBufferId;
    int geometryType = 4;
    private String id;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setGeometryType(int type) {
        this.geometryType = type;
    }

    public void setIndexData(int[] indexData) {
        if (indexData == null) {
            return;
        }
        this.nrOfIndices = indexData.length;
        this.indexByteBufferSize = 4 * this.nrOfIndices;
        this.indexBuffer = BufferUtil.directIntBuffer(this.nrOfIndices);
        this.indexBuffer.put(indexData, 0, this.nrOfIndices);
        this.indexBufferModified = true;
    }

    private void setNrOfVertices(int nvert) {
        if (this.nrOfVertices <= 0) {
            this.nrOfVertices = nvert;
        } else if (this.nrOfVertices != nvert) {
            throw new RuntimeException("GLBasicMesh: attributes with unequal number of vertices");
        }
    }

    public int addGLVertexAttribute(VertexAttribute va) {
        int attrNum = this.attributeList.size();
        GLVertexAttribute attr = new GLVertexAttribute(va);
        this.setNrOfVertices(attr.getNrOfVertices());
        this.attributeList.add(attr);
        return attrNum;
    }

    public void setVertexData(int attrNum, float[] vertexData) {
        this.attributeList.get(attrNum).setVertexData(vertexData);
    }

    public float[] getVertexData(int attrNum, float[] vertexData) {
        return this.attributeList.get(attrNum).getVertexData(vertexData);
    }

    @Override
    public void glInit(GLRenderContext gl) {
        IntBuffer bufNames = BufferUtil.directIntBuffer(2);
        gl.glGenBuffers(2, bufNames);
        this.vertexBufferId = bufNames.get(0);
        this.indexBufferId = bufNames.get(1);
        int[] progarray = new int[1];
        gl.glGetIntegerv(35725, progarray);
        int prog = progarray[0];
        this.bindShaderProg(gl, prog);
    }

    public void bindShaderProg(GLRenderContext gl, int prog) {
        int bufferOffset = 0;
        for (GLVertexAttribute attr : this.attributeList) {
            int index = attr.setAttributeIndex(gl, prog);
            if (index == -1) continue;
            attr.setArrayBufferOffset(bufferOffset);
            bufferOffset += attr.getByteBufferSize();
        }
        int arrayBufferSize = bufferOffset;
        gl.glBindBuffer(34962, this.vertexBufferId);
        gl.glBufferData(34962, arrayBufferSize, (FloatBuffer)null, 35040);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        gl.glDisableClientState(32887);
        gl.glBindBuffer(34962, this.vertexBufferId);
        for (GLVertexAttribute attr : this.attributeList) {
            attr.glRender(gl);
        }
        if (this.indexBuffer != null) {
            gl.glBindBuffer(34963, this.indexBufferId);
            if (this.indexBufferModified) {
                this.indexBuffer.rewind();
                gl.glBufferData(34963, this.indexByteBufferSize, this.indexBuffer, 35044);
                this.indexBufferModified = false;
            }
            gl.glDisableClientState(32887);
            gl.glDrawRangeElements(this.geometryType, 0, this.nrOfVertices, this.nrOfIndices, 5125, 0L);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("GLBasic/SkinnedMesh \"");
        buf.append(this.id);
        buf.append('\"');
        buf.append(" nrOfVertices: ");
        buf.append(this.nrOfVertices);
        buf.append(" nrOfIndices: ");
        buf.append(this.nrOfIndices);
        for (GLVertexAttribute va : this.attributeList) {
            buf.append('\n');
            va.appendTo(buf);
        }
        return buf.toString();
    }
}

