/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.lwjgl;

import hmi.graphics.lwjgl.LWJGLContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.util.ClockListener;
import hmi.util.Console;
import hmi.util.Terminator;
import java.awt.Canvas;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;

public class LWJGLRenderer1
implements ClockListener,
Terminator {
    public static Logger logger = Logger.getLogger("hmi.graphics.jogl.gLWJGLRenderer1");
    private PixelFormat pf;
    private GLRenderObject scene;
    private LWJGLContext glc;
    private ClockListener clockListener;
    private volatile double mediaTime;
    private boolean useVsync = true;
    private double fovy = 27.0;
    private double aspect;
    private int width;
    private int height;
    private double left;
    private double right;
    private double bottom;
    private double top;
    private double near = 1.0;
    private double far = 256.0;
    private ConcurrentLinkedQueue<Runnable> taskList = new ConcurrentLinkedQueue();
    private volatile boolean terminated = false;

    public LWJGLRenderer1(int numFSAA_Samples, int numStencilBits, int width, int height) {
        this.width = width;
        this.height = height;
        this.pf = numFSAA_Samples < 2 ? new PixelFormat() : new PixelFormat().withSamples(numFSAA_Samples);
        if (numStencilBits > 0) {
            this.pf = this.pf.withStencilBits(numStencilBits);
        }
        Console.addTerminator((Terminator)this);
    }

    public boolean terminate() {
        if (this.terminated) {
            return true;
        }
        this.destroy();
        Console.delay((long)200L);
        return true;
    }

    public void destroy() {
        System.out.println("render.destroy");
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.addTask(new Runnable(){

            @Override
            public void run() {
                System.out.println("running destroy....");
                Display.destroy();
                System.exit(0);
            }
        });
        System.out.println("terminate task added...");
    }

    public void setDisplayParent(final Canvas canvas) {
        this.addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    Display.setParent((Canvas)canvas);
                }
                catch (LWJGLException e) {
                    throw new RuntimeException("LWJGLRenderer1.setDisplayParent: " + (Object)((Object)e));
                }
            }
        });
    }

    public void setScene(GLRenderObject scene) {
        this.scene = scene;
    }

    public void setClockListener(ClockListener listener) {
        this.clockListener = listener;
    }

    public void initTime(double t) {
        if (this.clockListener != null) {
            this.clockListener.initTime(t);
        }
        this.initLWJGL();
    }

    public void addTask(Runnable r) {
        System.out.println("addTask...");
        this.taskList.add(r);
    }

    public void initLWJGL() {
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.width, this.height));
            Display.setTitle((String)"MyCanvas");
            Display.create((PixelFormat)this.pf);
            this.reshape(0, 0, this.width, this.height);
            Display.setVSyncEnabled((boolean)this.useVsync);
            Keyboard.create();
        }
        catch (LWJGLException e) {
            throw new RuntimeException("LWJGL Display/Keyboard cannot initialize: " + (Object)((Object)e));
        }
        this.glc = new LWJGLContext();
        if (this.scene != null) {
            this.scene.glInit(this.glc);
        }
    }

    public void updateLWJGL() {
        Runnable task = this.taskList.poll();
        while (task != null) {
            task.run();
            task = this.taskList.poll();
        }
        if (this.terminated) {
            return;
        }
        if (this.scene != null) {
            this.scene.glRender(this.glc);
        }
        Display.update();
        Keyboard.poll();
        while (Keyboard.next()) {
            int character_code = Keyboard.getEventCharacter() & 0xFFFF;
            Console.println((String)("Checking key:" + Keyboard.getKeyName((int)Keyboard.getEventKey())));
            Console.println((String)("Pressed:" + Keyboard.getEventKeyState()));
            Console.println((String)("Key character code: 0x" + Integer.toHexString(character_code)));
            Console.println((String)("Key character: " + Keyboard.getEventCharacter()));
            Console.println((String)("Repeat event: " + Keyboard.isRepeatEvent()));
        }
    }

    public void time(double t) {
        this.mediaTime = t;
        if (this.clockListener != null) {
            this.clockListener.time(t);
        }
        this.updateLWJGL();
    }

    public void setVsync(boolean useVsync) {
        this.useVsync = useVsync;
    }

    public void setFOVY(double fovy) {
        this.fovy = fovy;
    }

    public void setNear(double near) {
        this.near = near;
    }

    public void setFar(double far) {
        this.far = far;
    }

    private void calculateFrustumFromFOVY() {
        this.aspect = (double)this.width / (double)this.height;
        this.top = this.near * Math.tan(this.fovy * Math.PI / 360.0);
        this.bottom = -this.top;
        this.right = this.aspect * this.top;
        this.left = -this.right;
    }

    public void reshape(int x, int y, int w, int h) {
        this.width = w;
        this.height = h;
        if (this.height <= 0) {
            this.height = 1;
        }
        GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        this.calculateFrustumFromFOVY();
        GL11.glFrustum((double)this.left, (double)this.right, (double)this.bottom, (double)this.top, (double)this.near, (double)this.far);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }
}

