/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.lwjgl;

import hmi.graphics.lwjgl.LWJGLContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.util.ClockListener;
import hmi.util.Console;
import java.awt.Canvas;
import java.awt.EventQueue;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;

public class LWJGLRenderer
implements ClockListener {
    public static Logger logger = Logger.getLogger("hmi.graphics.jogl.gLWJGLRenderer");
    private PixelFormat pf;
    private GLRenderObject scene;
    private LWJGLContext glc;
    private ClockListener clockListener;
    private volatile double mediaTime;
    private boolean useVsync = true;
    private double fovy = 27.0;
    private double aspect;
    private int width;
    private int height;
    private double left;
    private double right;
    private double bottom;
    private double top;
    private double near = 1.0;
    private double far = 256.0;
    private Runnable updater;

    public LWJGLRenderer(int numFSAA_Samples, int numStencilBits, int width, int height) {
        this.width = width;
        this.height = height;
        this.pf = numFSAA_Samples < 2 ? new PixelFormat() : new PixelFormat().withSamples(numFSAA_Samples);
        if (numStencilBits > 0) {
            this.pf = this.pf.withStencilBits(numStencilBits);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LWJGLRenderer.this.initLWJGL();
            }
        });
        this.updater = new Runnable(){

            @Override
            public void run() {
                LWJGLRenderer.this.updateLWJGL();
            }
        };
    }

    public void destroy() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.destroy();
                System.exit(0);
            }
        });
    }

    public void setDisplayParent(final Canvas canvas) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Display.setParent((Canvas)canvas);
                }
                catch (LWJGLException e) {
                    throw new RuntimeException("LWJGLRenderer.setDisplayParent: " + (Object)((Object)e));
                }
            }
        });
    }

    public void setScene(GLRenderObject scene) {
        this.scene = scene;
    }

    public void setClockListener(ClockListener listener) {
        this.clockListener = listener;
    }

    public void initTime(double t) {
    }

    public void initLWJGL() {
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.width, this.height));
            Display.setTitle((String)"MyGearsCanvas");
            Display.create();
            this.reshape(0, 0, this.width, this.height);
        }
        catch (LWJGLException e) {
            throw new RuntimeException("LWJGL Display cannot initialize: " + (Object)((Object)e));
        }
        this.glc = new LWJGLContext();
    }

    public void updateLWJGL() {
        if (Display.isCloseRequested()) {
            Console.println((String)"CloseRequested");
        } else {
            Display.update();
        }
    }

    public void time(double t) {
        this.mediaTime = t;
        EventQueue.invokeLater(this.updater);
    }

    public void setVsync(boolean useVsync) {
        this.useVsync = useVsync;
    }

    public void setFOVY(double fovy) {
        this.fovy = fovy;
    }

    public void setNear(double near) {
        this.near = near;
    }

    public void setFar(double far) {
        this.far = far;
    }

    private void calculateFrustumFromFOVY() {
        this.aspect = (double)this.width / (double)this.height;
        this.top = this.near * Math.tan(this.fovy * Math.PI / 360.0);
        this.bottom = -this.top;
        this.right = this.aspect * this.top;
        this.left = -this.right;
    }

    public void reshape(int x, int y, int w, int h) {
        this.width = w;
        this.height = h;
        if (this.height <= 0) {
            this.height = 1;
        }
        GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        this.calculateFrustumFromFOVY();
        GL11.glFrustum((double)this.left, (double)this.right, (double)this.bottom, (double)this.top, (double)this.near, (double)this.far);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }
}

