/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.jogl;

import hmi.graphics.jogl.JOGLContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.util.ClockListener;
import java.awt.Component;
import java.awt.event.KeyListener;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLJPanel;

public class JOGLRenderer
implements GLEventListener,
ClockListener {
    private GLAutoDrawable glDrawable;
    private GLRenderObject scene;
    private JOGLContext glc;
    private ClockListener clockListener;
    private volatile double mediaTime;
    private volatile boolean joglInitialized = false;
    private boolean useVsync = true;
    public static final double DEFAULT_FOVY = 27.0;
    public static final double DEFAULT_NEAR = 1.0;
    public static final double DEFAULT_FAR = 256.0;
    private double fovy = 27.0;
    private double aspect;
    private int width;
    private int height;
    private double left;
    private double right;
    private double bottom;
    private double top;
    private double near = 1.0;
    private double far = 256.0;
    private static final double FULLCIRCLE_DEGREES = 360.0;

    public JOGLRenderer(GLAutoDrawable glDrawable) {
        this.glDrawable = glDrawable;
        if (glDrawable == null) {
            throw new RuntimeException("JOGLRenderer: null glDrawable");
        }
        glDrawable.addGLEventListener((GLEventListener)this);
        this.glc = new JOGLContext();
    }

    public JOGLRenderer(int numFSAASamples, int numStencilBits) {
        GLCapabilities cap = new GLCapabilities();
        if (numFSAASamples < 2) {
            cap.setSampleBuffers(false);
        } else {
            cap.setSampleBuffers(true);
            cap.setNumSamples(numFSAASamples);
        }
        if (numStencilBits > 0) {
            cap.setStencilBits(numStencilBits);
        }
        this.glDrawable = new GLCanvas(cap);
        this.glDrawable.addGLEventListener((GLEventListener)this);
        this.glc = new JOGLContext();
    }

    public JOGLRenderer(int numFSAA_Samples) {
        this(numFSAA_Samples, 0);
    }

    public void useDebugGL() {
        this.glDrawable.setGL((GL)new DebugGL(this.glDrawable.getGL()));
    }

    public void addKeyListener(KeyListener listener) {
        if (this.glDrawable instanceof GLCanvas) {
            ((GLCanvas)this.glDrawable).addKeyListener(listener);
        } else if (this.glDrawable instanceof GLJPanel) {
            ((GLJPanel)this.glDrawable).addKeyListener(listener);
        } else {
            throw new IllegalArgumentException("JOGLRendere.addKeyListener called for unknown type of GLAutoDrawable");
        }
    }

    public Component getAWTComponent() {
        return (Component)this.glDrawable;
    }

    public void setScene(GLRenderObject scene) {
        this.scene = scene;
    }

    public void setClockListener(ClockListener listener) {
        this.clockListener = listener;
    }

    public void initTime(double t) {
        this.mediaTime = t;
        if (this.clockListener != null) {
            this.clockListener.initTime(t);
        }
    }

    public void time(double t) {
        this.mediaTime = t;
        if (this.joglInitialized) {
            if (this.clockListener != null) {
                this.clockListener.time(this.mediaTime);
            }
            this.glDrawable.display();
        }
    }

    public void setVsync(boolean useVsync) {
        this.useVsync = useVsync;
    }

    public void init(GLAutoDrawable glDrawable) {
        this.joglInitialized = false;
        GL gl = glDrawable.getGL();
        this.glc.setGL(gl);
        gl.setSwapInterval(this.useVsync ? 1 : 0);
        if (this.scene == null) {
            return;
        }
        this.scene.glInit(this.glc);
        this.joglInitialized = true;
    }

    public void display(GLAutoDrawable glDrawable) {
        this.glc.setGL(glDrawable.getGL());
        if (this.scene != null) {
            this.scene.glRender(this.glc);
        }
    }

    public void displayChanged(GLAutoDrawable glDrawable, boolean modeChanged, boolean deviceChanged) {
    }

    public void setFOVY(double fovy) {
        this.fovy = fovy;
    }

    public void setNear(double near) {
        this.near = near;
    }

    public void setFar(double far) {
        this.far = far;
    }

    private void calculateFrustumFromFOVY() {
        this.aspect = (double)this.width / (double)this.height;
        this.top = this.near * Math.tan(this.fovy * Math.PI / 360.0);
        this.bottom = -this.top;
        this.right = this.aspect * this.top;
        this.left = -this.right;
    }

    public void reshape(GLAutoDrawable glDrawable, int x, int y, int w, int h) {
        GL gl = glDrawable.getGL();
        this.reshape(gl, x, y, w, h);
    }

    public void reshape(GL gl, int x, int y, int w, int h) {
        this.width = w;
        this.height = h;
        if (this.height <= 0) {
            this.height = 1;
        }
        gl.glViewport(0, 0, this.width, this.height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.calculateFrustumFromFOVY();
        gl.glFrustum(this.left, this.right, this.bottom, this.top, this.near, this.far);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }
}

