/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.geometry;

import java.util.logging.Logger;

public class Triangulator {
    private float[] vertexCoords;
    private int vertexStride;
    private int vertexOffset;
    private int[] polyIndex;
    private int polyVCount;
    private float nx;
    private float ny;
    private float nz;
    private static Logger logger = Logger.getLogger("hmi.graphics.geometry");

    public int[] triangulate(float[] vertexCoords, int vertexStride, int[] indices, int[] vCounts) {
        this.vertexCoords = vertexCoords;
        this.vertexOffset = 0;
        this.vertexStride = vertexStride;
        int nrOfTris = 0;
        int maxVCount = 0;
        for (int p = 0; p < vCounts.length; ++p) {
            int vcount = vCounts[p];
            if (vcount > maxVCount) {
                maxVCount = vcount;
            }
            if (vcount < 3) {
                logger.info("Triangulator polygon with only " + vcount + " vertices");
                continue;
            }
            nrOfTris += vcount - 2;
        }
        this.polyIndex = new int[maxVCount];
        int nrOfNewIndices = 3 * nrOfTris;
        int triangleOffset = 0;
        int[] newIndices = new int[nrOfNewIndices];
        int indexOffset = 0;
        for (int p = 0; p < vCounts.length; ++p) {
            this.polyVCount = vCounts[p];
            for (int i = 0; i < this.polyVCount; ++i) {
                this.polyIndex[i] = indices[indexOffset + i];
            }
            this.calcNormal();
            int triCount = this.triangulatePolygon(newIndices, triangleOffset);
            indexOffset += vCounts[p];
            triangleOffset += 3 * triCount;
        }
        return newIndices;
    }

    private void calcNormal() {
        this.nx = 0.0f;
        this.ny = 0.0f;
        this.nz = 0.0f;
        int vi = this.vertexOffset + this.vertexStride * this.polyIndex[0];
        float p0x = this.vertexCoords[vi];
        float p0y = this.vertexCoords[vi + 1];
        float p0z = this.vertexCoords[vi + 2];
        vi = this.vertexOffset + this.vertexStride * this.polyIndex[1];
        float bx = this.vertexCoords[vi] - p0x;
        float by = this.vertexCoords[vi + 1] - p0y;
        float bz = this.vertexCoords[vi + 2] - p0z;
        for (int pi = 1; pi < this.polyVCount; ++pi) {
            float ax = bx;
            float ay = by;
            float az = bz;
            vi = this.vertexOffset + this.vertexStride * this.polyIndex[pi];
            bx = this.vertexCoords[vi] - p0x;
            by = this.vertexCoords[vi + 1] - p0y;
            bz = this.vertexCoords[vi + 2] - p0z;
            this.nx += ay * bz - az * by;
            this.ny += az * bx - ax * bz;
            this.nz += ax * by - ay * bx;
        }
    }

    private boolean toLeft(int pi, int qi, int ri) {
        int vqi = this.vertexOffset + this.vertexStride * this.polyIndex[qi];
        int vpi = this.vertexOffset + this.vertexStride * this.polyIndex[pi];
        float uy = this.vertexCoords[vqi + 1] - this.vertexCoords[vpi + 1];
        int vri = this.vertexOffset + this.vertexStride * this.polyIndex[ri];
        float vz = this.vertexCoords[vri + 2] - this.vertexCoords[vqi + 2];
        float uz = this.vertexCoords[vqi + 2] - this.vertexCoords[vpi + 2];
        float vy = this.vertexCoords[vri + 1] - this.vertexCoords[vqi + 1];
        float crx = uy * vz - uz * vy;
        float vx = this.vertexCoords[vri] - this.vertexCoords[vqi];
        float ux = this.vertexCoords[vqi] - this.vertexCoords[vpi];
        float cry = uz * vx - ux * vz;
        float crz = ux * vy - uy * vx;
        float dot = crx * this.nx + cry * this.ny + crz * this.nz;
        return dot > 0.0f;
    }

    private boolean insideTriangle(int pi0, int pi1, int pi2, int q) {
        if (!this.toLeft(pi0, pi1, q)) {
            return false;
        }
        if (!this.toLeft(pi1, pi2, q)) {
            return false;
        }
        return this.toLeft(pi2, pi0, q);
    }

    public boolean isEar(int pi) {
        int jp;
        int jm = this.prev(pi);
        if (!this.toLeft(jm, pi, jp = this.next(pi))) {
            return false;
        }
        for (int k = 0; k < this.polyVCount; ++k) {
            if (k == jm || k == pi || k == jp || !this.insideTriangle(jm, pi, jp, k)) continue;
            return false;
        }
        return true;
    }

    private int prev(int p) {
        return p - 1 < 0 ? this.polyVCount - 1 : p - 1;
    }

    private int next(int p) {
        return (p + 1) % this.polyVCount;
    }

    private void delete(int pi) {
        --this.polyVCount;
        for (int i = pi; i < this.polyVCount; ++i) {
            this.polyIndex[i] = this.polyIndex[i + 1];
        }
    }

    private int triangulatePolygon(int[] triangles, int triangleOffset) {
        int triCount = 0;
        while (this.polyVCount > 3) {
            boolean earFound = false;
            for (int p = 0; !earFound && p < this.polyVCount; ++p) {
                earFound = this.isEar(p);
                if (!earFound) continue;
                triangles[triangleOffset + 3 * triCount] = this.polyIndex[this.prev(p)];
                triangles[triangleOffset + 3 * triCount + 1] = this.polyIndex[p];
                triangles[triangleOffset + 3 * triCount + 2] = this.polyIndex[this.next(p)];
                ++triCount;
                this.delete(p);
            }
        }
        triangles[triangleOffset + 3 * triCount] = this.polyIndex[0];
        triangles[triangleOffset + 3 * triCount + 1] = this.polyIndex[1];
        triangles[triangleOffset + 3 * triCount + 2] = this.polyIndex[2];
        return ++triCount;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n=== Triangulator polyVCount = ");
        buf.append(this.polyVCount);
        buf.append("===");
        for (int i = 0; i < this.polyVCount; ++i) {
            int vi = this.vertexOffset + this.vertexStride * this.polyIndex[i];
            buf.append("\nvertex " + i + " polyIndex = " + this.polyIndex[i] + "   coords = " + this.vertexCoords[vi] + ", " + this.vertexCoords[vi + 1] + ", " + this.vertexCoords[vi + 2]);
            int j0 = this.prev(i);
            int j2 = this.next(i);
            buf.append("\ntoLeft " + j0 + " -- " + i + " -- " + j2 + " : " + this.toLeft(j0, i, j2));
            buf.append("\near: " + this.isEar(i));
        }
        return buf.toString();
    }
}

