/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.gen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GenLWJGLContext {
    private String lwjgldir = "src/hmi/graphics/lwjgl";
    private String gendir = "src/hmi/graphics/gen";
    private File headerFile = new File(this.gendir, "LWJGLContext.header");
    private File inp = new File(this.gendir, "GLF.def");
    private File outp = new File(this.lwjgldir, "LWJGLContext.java");
    private Scanner scan;
    private Scanner hscan;
    private PrintWriter pw;
    private Set<String> definedInHeader = new HashSet<String>();
    private Pattern pat = Pattern.compile("\\s*(GL\\w*)\\s+(\\w+)\\s+(\\w+)\\s*[(]([^)]*)[)].*");
    private Pattern hpat = Pattern.compile("\\s*public\\s+\\w+\\s+(\\w+)\\s*[(][^)]*[)].*");
    private Pattern argPat = Pattern.compile("\\s*(\\w+\\s*?)(\\[?\\s*?\\]?)\\s*(\\w+)\\s*,?\\s*(.*)");
    private Pattern useBufferPat = Pattern.compile("(.*Buffer.*)|(.*\\[\\].*)");

    private GenLWJGLContext() {
        Matcher matcher;
        String line;
        try {
            this.hscan = new Scanner(this.headerFile);
            this.scan = new Scanner(this.inp);
            this.pw = new PrintWriter(this.outp);
        }
        catch (FileNotFoundException e) {
            System.out.println("GenLWJGLContext: " + e);
            System.exit(0);
        }
        while (this.hscan.hasNextLine()) {
            line = this.hscan.nextLine();
            matcher = this.hpat.matcher(line);
            if (matcher.matches()) {
                String funcName = matcher.group(1);
                this.definedInHeader.add(funcName);
                System.out.println("header func: " + funcName);
            }
            this.pw.println(line);
        }
        while (this.scan.hasNextLine()) {
            line = this.scan.nextLine();
            matcher = this.pat.matcher(line);
            if (matcher.matches()) {
                String glVersion = matcher.group(1);
                String resultType = matcher.group(2);
                String funcName = matcher.group(3);
                String argTypes = matcher.group(4);
                this.lwjglCompile(glVersion, resultType, funcName, argTypes);
                continue;
            }
            this.pw.println(line);
        }
        this.pw.println("}");
        this.pw.close();
    }

    private void lwjglCompile(String glVersion, String resultType, String funcName, String argTypes) {
        if (this.definedInHeader.contains(funcName)) {
            return;
        }
        this.pw.print("   public " + resultType + " " + funcName + "(" + argTypes + ") { ");
        if (!resultType.equals("void")) {
            this.pw.print("return ");
        }
        this.pw.print(glVersion + "." + this.compileFuncName(funcName) + "(");
        Matcher rt = this.useBufferPat.matcher(argTypes);
        boolean useBuffer = rt.matches();
        Matcher mt = this.argPat.matcher(argTypes);
        mt = this.argPat.matcher(argTypes);
        boolean needComma = false;
        while (mt.matches()) {
            String argType = mt.group(1);
            String arrayBrackets = mt.group(2);
            String argName = mt.group(3);
            if (!useBuffer || !argName.equals("buftype") && !argName.equals("bufcount")) {
                if (needComma) {
                    this.pw.print(", ");
                }
                this.lwjglCompileArg(argType, !arrayBrackets.equals(""), argName);
                needComma = true;
            }
            argTypes = mt.group(4);
            mt = this.argPat.matcher(argTypes);
        }
        this.pw.println("); }");
    }

    private void lwjglCompileArg(String argType, boolean isArray, String argName) {
        if (isArray) {
            if (argType.equals("float")) {
                this.pw.print("BufferUtil.floatBuffer(");
            } else if (argType.equals("int")) {
                this.pw.print("BufferUtil.intBuffer(");
            } else if (argType.equals("byte")) {
                this.pw.print("BufferUtil.byteBuffer(");
            } else {
                System.out.println("GenLWJGLContext: cannot translate " + argType + "[] type parameter");
            }
            this.pw.print(argName);
            this.pw.print(")");
        } else if (argType.equals("String")) {
            this.pw.print("BufferUtil.stringToNullTerminatedByteBuffer(");
            this.pw.print(argName);
            this.pw.print(")");
        } else {
            this.pw.print(argName);
        }
    }

    private String compileFuncName(String funcName) {
        if (funcName.endsWith("fv") || funcName.endsWith("iv")) {
            return funcName.substring(0, funcName.length() - 2);
        }
        if (funcName.endsWith("v")) {
            return funcName.substring(0, funcName.length() - 1);
        }
        if (funcName.endsWith("Matrixf")) {
            return funcName.substring(0, funcName.length() - 1);
        }
        return funcName;
    }

    public static void main(String[] arg) {
        new GenLWJGLContext();
    }
}

