/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.gen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GenGLBinding {
    private String opengldir = "src/hmi/graphics/opengl";
    private String gendir = "src/hmi/graphics/gen";
    private File headerFile = new File(this.gendir, "GLBinding.header");
    private File funcFile = new File(this.gendir, "GLF.def");
    private File outp = new File(this.opengldir, "GLBinding.java");
    private Scanner scan;
    private Scanner hscan;
    private PrintWriter pw;
    private Pattern pat = Pattern.compile("\\s*(GL\\w+)\\s*+(.*)");

    private GenGLBinding() {
        try {
            this.hscan = new Scanner(this.headerFile);
            this.scan = new Scanner(this.funcFile);
            this.pw = new PrintWriter(this.outp);
        }
        catch (FileNotFoundException e) {
            System.out.println("GenGLBinding: " + e);
            System.exit(0);
        }
        while (this.hscan.hasNextLine()) {
            this.pw.println(this.hscan.nextLine());
        }
        while (this.scan.hasNextLine()) {
            String line = this.scan.nextLine();
            Matcher matcher = this.pat.matcher(line);
            if (matcher.matches()) {
                String funcDef = matcher.group(2);
                this.pw.println("   " + funcDef);
                continue;
            }
            this.pw.println(line);
        }
        this.pw.println("}");
        this.pw.close();
    }

    public static void main(String[] arg) {
        new GenGLBinding();
    }
}

