/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada.scenegraph;

import hmi.graphics.collada.BindMaterial;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.Controller;
import hmi.graphics.collada.Geometry;
import hmi.graphics.collada.Input;
import hmi.graphics.collada.InstanceGeometry;
import hmi.graphics.collada.Mesh;
import hmi.graphics.collada.Morph;
import hmi.graphics.collada.PolyList;
import hmi.graphics.collada.Polygons;
import hmi.graphics.collada.PrimitiveMeshElement;
import hmi.graphics.collada.Skin;
import hmi.graphics.collada.Source;
import hmi.graphics.collada.scenegraph.MaterialTranslator;
import hmi.graphics.scenegraph.GMaterial;
import hmi.graphics.scenegraph.GMesh;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GShape;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.graphics.scenegraph.VertexWeights;
import hmi.math.Mat4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class InstanceGeometryTranslator {
    private static final List<GShape> EMPTY_GSHAPE_LIST = new ArrayList<GShape>(0);
    private static final float EPSMIN = 0.1f;
    private static final float EPSPLUS = 0.05f;
    private static Map<String, String> attributeNameTranslation = new HashMap<String, String>();

    private InstanceGeometryTranslator() {
    }

    public static void addGShapes(Collada collada, List<InstanceGeometry> instanceGeometries, GNode gnode) {
        if (instanceGeometries != null) {
            for (InstanceGeometry igeom : instanceGeometries) {
                Geometry geom = igeom.getGeometry();
                if (geom == null) {
                    collada.warning("Collada InstanceGeometryTranslator: instance geometry: " + igeom.getURL() + " could not be found");
                    continue;
                }
                BindMaterial bindMaterial = igeom.getBindMaterial();
                List<GShape> gshapeList = InstanceGeometryTranslator.getGShapeList(collada, geom, bindMaterial);
                gnode.addGShapes(gshapeList);
            }
        }
    }

    public static List<GShape> getGShapeList(Collada collada, Geometry geom, BindMaterial bindMaterial) {
        ArrayList<GShape> result = new ArrayList<GShape>();
        String geomName = geom.getIdOrName();
        Mesh mesh = geom.getMesh();
        List<PrimitiveMeshElement> primList = mesh.getPrimitiveMeshElements();
        ArrayList<GMesh> gmeshList = new ArrayList<GMesh>(primList.size());
        ArrayList<Input> verticesInputs = mesh.getVertices().getInputs();
        int counter = 0;
        for (PrimitiveMeshElement prim : primList) {
            MaterialTranslator.GMaterialPlusChannelBindings gmatBinding = MaterialTranslator.primitiveToGMaterial(collada, prim, bindMaterial);
            GMaterial gmaterial = gmatBinding.getGMaterial();
            Map<String, String> texCoordBindings = gmatBinding.getBindings();
            GMesh gmesh = InstanceGeometryTranslator.primitiveToGMesh(collada, prim, verticesInputs, null, null, geomName, texCoordBindings);
            gmeshList.add(gmesh);
            String shapeName = primList.size() <= 1 ? geomName : geomName + "-" + counter;
            ++counter;
            gmesh.setId(shapeName);
            GShape gs = new GShape(gmesh, gmaterial, shapeName);
            result.add(gs);
        }
        return result;
    }

    public static List<GShape> getSkinnedGShapeList(Collada collada, Skin skin, String[] skeletonIds, BindMaterial bindMaterial, List<GSkinnedMesh> skinnedMeshes) {
        ArrayList<GShape> result = new ArrayList<GShape>();
        Geometry geom = skin.getGeometry();
        Geometry[] targetGeoms = null;
        String[] targetIds = null;
        if (geom == null) {
            Controller morphController = skin.getController();
            if (morphController == null) {
                collada.warning("Collada Translator: skin geometry or morph controller: " + skin.getSource() + " could not be found");
                return EMPTY_GSHAPE_LIST;
            }
            Morph morph = morphController.getMorph();
            if (morph == null) {
                collada.warning("Collada Translator: Morph controller expected within Skin");
                return EMPTY_GSHAPE_LIST;
            }
            geom = morph.getBaseGeometry();
            targetIds = morph.getMorphTargetIds();
            targetGeoms = morph.getTargetGeometries();
        }
        String geomName = geom.getIdOrName();
        Mesh mesh = geom.getMesh();
        ArrayList<Input> verticesInputs = mesh.getVertices().getInputs();
        List<PrimitiveMeshElement> primList = mesh.getPrimitiveMeshElements();
        ArrayList<ArrayList<Input>> targetVerticesInputs = null;
        if (targetGeoms != null) {
            targetVerticesInputs = new ArrayList<ArrayList<Input>>(targetGeoms.length);
            for (int i = 0; i < targetGeoms.length; ++i) {
                Mesh tgMesh = targetGeoms[i].getMesh();
                ArrayList<Input> tgVerticesInputs = tgMesh.getVertices().getInputs();
                targetVerticesInputs.add(tgVerticesInputs);
            }
        }
        ArrayList<GSkinnedMesh> gmeshList = new ArrayList<GSkinnedMesh>(primList.size());
        int counter = 0;
        for (PrimitiveMeshElement prim : primList) {
            MaterialTranslator.GMaterialPlusChannelBindings gmatBinding = MaterialTranslator.primitiveToGMaterial(collada, prim, bindMaterial);
            GMaterial gmaterial = gmatBinding.getGMaterial();
            Map<String, String> texCoordBindings = gmatBinding.getBindings();
            GSkinnedMesh gmesh = InstanceGeometryTranslator.primitiveToGSkinnedMesh(collada, prim, verticesInputs, targetVerticesInputs, targetIds, skin, skeletonIds, geomName, texCoordBindings);
            gmeshList.add(gmesh);
            skinnedMeshes.add(gmesh);
            String shapeName = primList.size() <= 1 ? geomName : geomName + "-" + counter;
            ++counter;
            gmesh.setId(shapeName);
            GShape gs = new GShape(gmesh, gmaterial, shapeName);
            result.add(gs);
        }
        return result;
    }

    private static GMesh.MeshType convertType(Mesh.MeshType colladaType) {
        switch (colladaType) {
            case Triangles: {
                return GMesh.MeshType.Triangles;
            }
            case Trifans: {
                return GMesh.MeshType.Trifans;
            }
            case Tristrips: {
                return GMesh.MeshType.Tristrips;
            }
            case Polygons: {
                return GMesh.MeshType.Polygons;
            }
            case Polylist: {
                return GMesh.MeshType.Polylist;
            }
            case Lines: {
                return GMesh.MeshType.Undefined;
            }
            case Linestrips: {
                return GMesh.MeshType.Undefined;
            }
        }
        return GMesh.MeshType.Undefined;
    }

    private static GMesh primitiveToGMesh(Collada collada, PrimitiveMeshElement prim, ArrayList<Input> verticesInputs, ArrayList<ArrayList<Input>> targetVerticesInputs, String[] targetIds, String geomName, Map<String, String> texCoordBindings) {
        prim.createIndexArrays();
        GMesh gmesh = new GMesh();
        gmesh.setId(geomName);
        gmesh.setMeshType(InstanceGeometryTranslator.convertType(prim.getMeshType()));
        if (targetIds != null) {
            gmesh.setMorphTargets(targetIds);
        }
        ArrayList<Input> primInputs = prim.getInputs();
        for (Input inp : primInputs) {
            String semantic = inp.getSemantic();
            int offset = inp.getOffset();
            int[] indices = prim.getIndices(offset);
            if (semantic.equals("VERTEX")) {
                for (Input vertexInput : verticesInputs) {
                    String vertexSemantic = vertexInput.getSemantic();
                    String attributeName = InstanceGeometryTranslator.translateAttributeName(vertexSemantic, -1, null);
                    if (attributeName == null) {
                        collada.warning("InstanceGeometryTranslator.primitiveToGMesh: cannot handle " + vertexSemantic + " attribute");
                        continue;
                    }
                    if (attributeName.equals("NotUsed")) continue;
                    InstanceGeometryTranslator.addGMeshData(-1, gmesh, vertexInput, indices, attributeName);
                    if (targetVerticesInputs == null) continue;
                    int tgIndex = 0;
                    for (ArrayList arrayList : targetVerticesInputs) {
                        for (Input tgVertexInput : arrayList) {
                            String tgVertexSemantic = tgVertexInput.getSemantic();
                            if (!tgVertexSemantic.equals(vertexSemantic)) continue;
                            InstanceGeometryTranslator.addGMeshData(tgIndex, gmesh, tgVertexInput, indices, attributeName);
                        }
                        ++tgIndex;
                    }
                }
                continue;
            }
            int set = inp.getSet();
            String attributeName = InstanceGeometryTranslator.translateAttributeName(semantic, set, texCoordBindings);
            if (attributeName == null) {
                collada.warning("InstanceGeometryTranslator.primitiveToGMesh: cannot handle " + semantic + " attribute");
                continue;
            }
            if (attributeName.equals("NotUsed")) continue;
            InstanceGeometryTranslator.addGMeshData(-1, gmesh, inp, indices, attributeName);
            if (targetVerticesInputs == null) continue;
            int tgIndex = 0;
            for (ArrayList<Input> tgVerticesInputs : targetVerticesInputs) {
                for (Input input : tgVerticesInputs) {
                    String tgVertexSemantic = input.getSemantic();
                    if (!tgVertexSemantic.equals(semantic)) continue;
                    InstanceGeometryTranslator.addGMeshData(tgIndex, gmesh, input, indices, attributeName);
                }
                ++tgIndex;
            }
        }
        if (prim instanceof PolyList) {
            gmesh.setVCountData(((PolyList)prim).getVCounts());
        }
        if (prim instanceof Polygons) {
            gmesh.setVCountData(((Polygons)prim).getVCounts());
        }
        return gmesh;
    }

    private static GSkinnedMesh primitiveToGSkinnedMesh(Collada collada, PrimitiveMeshElement prim, ArrayList<Input> verticesInputs, ArrayList<ArrayList<Input>> targetVerticesInputs, String[] targetIds, Skin skin, String[] skeletonIds, String geomName, Map<String, String> texCoordBindings) {
        GMesh gm = InstanceGeometryTranslator.primitiveToGMesh(collada, prim, verticesInputs, targetVerticesInputs, targetIds, geomName, texCoordBindings);
        GSkinnedMesh gsm = new GSkinnedMesh(gm);
        float[] bindShapeMatrix = skin.getBindShapeMatrix();
        if (bindShapeMatrix != null) {
            gsm.affineTransform(bindShapeMatrix);
        }
        VertexWeights vertexWeights = InstanceGeometryTranslator.createVertexWeights(skin);
        vertexWeights.checkAccumulatedWeights(0.1f, 0.05f, true);
        gsm.setVertexWeights(vertexWeights);
        gsm.setSkeletonIds(skeletonIds);
        gsm.setJointSIDs(skin.getJointSIDs());
        float[] packedMatrices = skin.getInvBindMatrices();
        if (packedMatrices != null) {
            int nrOfMatrices = packedMatrices.length / 16;
            float[][] invBindMatrices = new float[nrOfMatrices][];
            for (int m = 0; m < nrOfMatrices; ++m) {
                invBindMatrices[m] = Mat4f.getMat4f();
                for (int i = 0; i < 16; ++i) {
                    invBindMatrices[m][i] = packedMatrices[16 * m + i];
                }
            }
            gsm.setInvBindMatrices(invBindMatrices);
        }
        return gsm;
    }

    private static VertexWeights createVertexWeights(Skin skin) {
        int[] vcount = skin.getVCount();
        int[] vc = Arrays.copyOf(vcount, vcount.length);
        int[] jointIndices = skin.getJointIndices();
        int[] ji = Arrays.copyOf(jointIndices, jointIndices.length);
        float[] jointWeights = skin.getJointWeights();
        float[] jw = Arrays.copyOf(jointWeights, jointWeights.length);
        return new VertexWeights(vc, ji, jw);
    }

    private static String translateAttributeName(String semantic, int set, Map<String, String> texCoordBindings) {
        if (semantic.equals("TEXCOORD")) {
            String fullTexCoord = semantic + set;
            String texCoord = texCoordBindings.get(fullTexCoord);
            if (texCoord == null) {
                return "NotUsed";
            }
            return texCoord;
        }
        return attributeNameTranslation.get(semantic);
    }

    private static void addGMeshData(int morphTarget, GMesh gm, Input inp, int[] indices, String attributeName) {
        String sourceURL = inp.getSource();
        if (sourceURL == null) {
            inp.getCollada().warning("InstanceGeometryTranslator.addMeshData: null sourceURL for Input");
            return;
        }
        Source source = inp.getCollada().getSource(inp.urlToId(sourceURL));
        if (source == null) {
            inp.getCollada().warning("InstanceGeometryTranslator.addMeshData: null source for Source URL " + sourceURL);
            return;
        }
        if (attributeName.startsWith("texCoord")) {
            String[] texCoordFieldNames = new String[]{"s", "t"};
            gm.setIndexedVertexData(morphTarget, attributeName, texCoordFieldNames.length, source.getHomogeneousFloatData(texCoordFieldNames), indices);
        } else {
            gm.setIndexedVertexData(morphTarget, attributeName, source.getNrOfNamedParams(), source.getHomogeneousFloatData(), indices);
        }
    }

    static {
        attributeNameTranslation.put("POSITION", "mcPosition");
        attributeNameTranslation.put("NORMAL", "mcNormal");
        attributeNameTranslation.put("COLOR", "color");
    }
}

