/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada.scenegraph;

import hmi.graphics.collada.BindMaterial;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.Controller;
import hmi.graphics.collada.InstanceController;
import hmi.graphics.collada.Skin;
import hmi.graphics.collada.scenegraph.InstanceGeometryTranslator;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GShape;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.util.Console;
import java.util.ArrayList;
import java.util.List;

public final class InstanceControllerTranslator {
    private static final List<GShape> EMPTY_GSHAPE_LIST = new ArrayList<GShape>(0);

    private InstanceControllerTranslator() {
    }

    public static void addInstanceControllerGShapes(Collada collada, List<InstanceController> instanceControllers, GNode gnode, List<GSkinnedMesh> skinnedMeshes) {
        for (InstanceController icontrol : instanceControllers) {
            List<GShape> gshapeList = InstanceControllerTranslator.instanceControllerToGShapeList(collada, icontrol, skinnedMeshes);
            gnode.addGShapes(gshapeList);
        }
    }

    public static List<GShape> instanceControllerToGShapeList(Collada collada, InstanceController icontrol, List<GSkinnedMesh> skinnedMeshes) {
        Controller controller = icontrol.getController();
        if (controller == null) {
            collada.warning("Collada Translator: instance controller: " + icontrol.getURL() + " could not be found");
            return EMPTY_GSHAPE_LIST;
        }
        Skin skin = controller.getSkin();
        if (skin == null) {
            collada.warning("Collada Translator: instance controller: " + icontrol.getURL() + " has no skin");
            return EMPTY_GSHAPE_LIST;
        }
        BindMaterial bindMaterial = icontrol.getBindMaterial();
        String[] skeletonIds = icontrol.getSkeletonIds();
        if (skeletonIds.length != 0) {
            List<GShape> gshapeList = InstanceGeometryTranslator.getSkinnedGShapeList(collada, skin, skeletonIds, bindMaterial, skinnedMeshes);
            return gshapeList;
        }
        Console.println((String)"InstanceControllerTranslator: Empty skeletonIds");
        return null;
    }
}

