/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada.scenegraph;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.InstanceController;
import hmi.graphics.collada.InstanceGeometry;
import hmi.graphics.collada.Node;
import hmi.graphics.collada.Scene;
import hmi.graphics.collada.TransformNode;
import hmi.graphics.collada.VisualScene;
import hmi.graphics.collada.scenegraph.InstanceControllerTranslator;
import hmi.graphics.collada.scenegraph.InstanceGeometryTranslator;
import hmi.graphics.collada.scenegraph.TransformTranslator;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.util.Console;
import java.util.ArrayList;
import java.util.List;

public final class ColladaTranslator {
    private ColladaTranslator() {
    }

    public static GScene colladaToGScene(Collada collada, float scale) {
        return ColladaTranslator.colladaToGScene(collada, null, scale, true);
    }

    public static GScene colladaToGScene(Collada collada, String renamingList, float scale) {
        return ColladaTranslator.colladaToGScene(collada, renamingList, scale, true);
    }

    public static GScene colladaToGScene(Collada collada, String renamingList, float scale, boolean setToHAnim) {
        Scene scene = collada.getScene();
        if (scene == null) {
            throw new RuntimeException("ColladaTranslator.colladaToGScene: Collada document without scene.");
        }
        GScene gscene = ColladaTranslator.colladaSceneToGScene(collada, scene);
        gscene.prepareSkinnedMeshes(renamingList, scale, setToHAnim);
        return gscene;
    }

    public static GScene colladaSceneToGScene(Collada collada, Scene scene) {
        if (scene.getInstanceVisualScene() == null || scene.getInstanceVisualScene().getURL() == null) {
            throw new RuntimeException("Translator.colladaSceneToGNode: Collada document with null visual_scene.");
        }
        String url = scene.getInstanceVisualScene().getURL();
        VisualScene vscene = (VisualScene)((Object)collada.getLibItem(collada.getLibrariesVisualScenes(), url));
        if (vscene == null) {
            throw new RuntimeException("ColladaTranslator.colladaSceneToGNode: visual_scene " + url + " could not be found.");
        }
        GScene gscene = new GScene();
        ArrayList<Node> rootNodes = vscene.getNodes();
        for (Node rootNode : rootNodes) {
            ArrayList<GSkinnedMesh> skinnedMeshes = new ArrayList<GSkinnedMesh>();
            GNode gRootNode = ColladaTranslator.colladaNodeToGNode(collada, rootNode, skinnedMeshes);
            gscene.addRootNode(gRootNode);
            gscene.addSkinnedMeshes(skinnedMeshes);
        }
        return gscene;
    }

    public static GNode colladaNodeToGNode(Collada collada, Node node, List<GSkinnedMesh> skinnedMeshes) {
        if (node == null) {
            return null;
        }
        GNode gnode = new GNode();
        String id = node.getId();
        String sid = node.getSid();
        String name = node.getName();
        if (id == null) {
            id = name;
        }
        gnode.setId(id);
        gnode.setSid(sid);
        gnode.setName(name);
        String type = node.getType();
        if (type != null) {
            gnode.setType(type);
        }
        List<TransformNode> transformList = node.getTransforms();
        TransformTranslator.setTransform(transformList, gnode);
        List<InstanceGeometry> instanceGeometries = node.getInstanceGeometries();
        InstanceGeometryTranslator.addGShapes(collada, instanceGeometries, gnode);
        List<InstanceController> instanceControllers = node.getInstanceControllers();
        if (!instanceControllers.isEmpty()) {
            ArrayList<InstanceController> instanceSkinControllers = new ArrayList<InstanceController>(instanceControllers.size());
            for (InstanceController ic : instanceControllers) {
                if (ic.getController().getSkin() == null) continue;
                instanceSkinControllers.add(ic);
            }
            InstanceControllerTranslator.addInstanceControllerGShapes(collada, instanceSkinControllers, gnode, skinnedMeshes);
            ArrayList<InstanceController> instanceMorphControllers = new ArrayList<InstanceController>(1);
            for (InstanceController ic : instanceControllers) {
                if (ic.getController().getMorph() == null) continue;
                instanceMorphControllers.add(ic);
            }
            if (!instanceMorphControllers.isEmpty()) {
                Console.println((String)"ColladaTranslator: cannot handle instance morph controller");
            }
        }
        for (Node childNode : node.getNodes()) {
            GNode gchild = ColladaTranslator.colladaNodeToGNode(collada, childNode, skinnedMeshes);
            gnode.addGNode(gchild);
        }
        return gnode;
    }
}

