/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Texcombiner;
import hmi.graphics.collada.Texenv;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class TexturePipeline
extends ColladaElement {
    private String param;
    private ArrayList<Texcombiner> texcombinerList = new ArrayList();
    private ArrayList<Texenv> texenvList = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "texture_pipeline";

    public TexturePipeline() {
    }

    public TexturePipeline(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        TexturePipeline.appendAttribute((StringBuilder)buf, (String)"param", (String)this.param);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.param = this.getOptionalAttribute("param", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        TexturePipeline.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.texcombinerList);
        TexturePipeline.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.texenvList);
        TexturePipeline.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Texcombiner.xmlTag())) {
                this.texcombinerList.add(new Texcombiner(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Texenv.xmlTag())) {
                this.texenvList.add(new Texenv(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("TexturePipeline: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.texcombinerList);
        this.addColladaNodes(this.texenvList);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

