/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Alpha;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Constant;
import hmi.graphics.collada.RGB;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Texcombiner
extends ColladaElement {
    private Constant constant;
    private RGB rgb;
    private Alpha alpha;
    private static final String XMLTAG = "texcombiner";

    public Texcombiner() {
    }

    public Texcombiner(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.constant);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.rgb);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.alpha);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Constant.xmlTag())) {
                this.constant = new Constant(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals("RGB.XMLTag")) {
                this.rgb = new RGB(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals("Alpha.XMLTag")) {
                this.alpha = new Alpha(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Texcombiner: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.constant);
        this.addColladaNode(this.rgb);
        this.addColladaNode(this.alpha);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

