/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Blinn;
import hmi.graphics.collada.Code;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ColladaImage;
import hmi.graphics.collada.Constant;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.FixedFunctionShader;
import hmi.graphics.collada.Include;
import hmi.graphics.collada.Lambert;
import hmi.graphics.collada.Newparam;
import hmi.graphics.collada.Pass;
import hmi.graphics.collada.Phong;
import hmi.graphics.collada.Setparam;
import hmi.graphics.collada.ShaderInclude;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TechniqueFX
extends ColladaElement {
    private Asset asset;
    private ArrayList<Newparam> newparamList;
    private ArrayList<Setparam> setparamList;
    private ArrayList<ColladaImage> imageList;
    private ArrayList<Code> codeList;
    private ArrayList<Pass> passList;
    private FixedFunctionShader shader;
    private ArrayList<Extra> extras;
    private ShaderInclude include;
    private static final String XMLTAG = "technique";

    public TechniqueFX() {
    }

    public TechniqueFX(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public List<Newparam> getNewparamList() {
        return this.newparamList;
    }

    public List<Setparam> getSetparamList() {
        return this.setparamList;
    }

    public List<ColladaImage> getImageList() {
        return this.imageList;
    }

    public List<Code> getCodeList() {
        return this.codeList;
    }

    public List<Pass> getPassList() {
        return this.passList;
    }

    public FixedFunctionShader getShader() {
        return this.shader;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.setSid(this.getRequiredAttribute("sid", attrMap, tokenizer));
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        TechniqueFX.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.newparamList);
        TechniqueFX.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.setparamList);
        TechniqueFX.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.imageList);
        TechniqueFX.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.codeList);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.include);
        TechniqueFX.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.passList);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.shader);
        TechniqueFX.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Newparam.xmlTag())) {
                if (this.newparamList == null) {
                    this.newparamList = new ArrayList();
                }
                this.newparamList.add(new Newparam(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Setparam.xmlTag())) {
                if (this.setparamList == null) {
                    this.setparamList = new ArrayList();
                }
                this.setparamList.add(new Setparam(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(ColladaImage.xmlTag())) {
                if (this.imageList == null) {
                    this.imageList = new ArrayList();
                }
                this.imageList.add(new ColladaImage(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Code.xmlTag())) {
                if (this.codeList == null) {
                    this.codeList = new ArrayList();
                }
                this.codeList.add(new Code(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Include.xmlTag())) {
                this.include = new ShaderInclude(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Pass.xmlTag())) {
                if (this.passList == null) {
                    this.passList = new ArrayList();
                }
                this.passList.add(new Pass(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Blinn.xmlTag())) {
                this.shader = new Blinn(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Constant.xmlTag())) {
                this.shader = new Constant(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Lambert.xmlTag())) {
                this.shader = new Lambert(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Phong.xmlTag())) {
                this.shader = new Phong(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                if (this.extras == null) {
                    this.extras = new ArrayList();
                }
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("TechniqueFX: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.asset);
        this.addColladaNodes(this.newparamList);
        this.addColladaNodes(this.setparamList);
        this.addColladaNodes(this.imageList);
        this.addColladaNodes(this.codeList);
        this.addColladaNode(this.include);
        this.addColladaNodes(this.passList);
        this.addColladaNode(this.shader);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

