/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Ambient;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Directional;
import hmi.graphics.collada.Point;
import hmi.graphics.collada.Spot;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class TechniqueCommonLight
extends ColladaElement {
    private Ambient ambient;
    private Point pointLight;
    private Directional directional;
    private Spot spot;
    private static final String XMLTAG = "technique_common";

    public TechniqueCommonLight() {
    }

    public TechniqueCommonLight(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String prof = this.getOptionalAttribute("profile", attrMap);
        if (prof != null && !prof.equals("COMMON")) {
            this.getCollada().warning("common_profile with profile attribute: " + prof + "  (ignored)");
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.ambient);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.pointLight);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.directional);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.spot);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Ambient.xmlTag())) {
                this.ambient = new Ambient(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Point.xmlTag())) {
                this.pointLight = new Point(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Directional.xmlTag())) {
                this.directional = new Directional(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Spot.xmlTag())) {
                this.spot = new Spot(this.getCollada(), tokenizer);
                continue;
            }
            super.decodeContent(tokenizer);
            this.getCollada().warning(tokenizer.getErrorMessage("TechniqueCommon (Light): skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.ambient);
        this.addColladaNode(this.pointLight);
        this.addColladaNode(this.directional);
        this.addColladaNode(this.spot);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

