/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.CommonColor;
import hmi.graphics.collada.ConstantAttenuation;
import hmi.graphics.collada.FalloffAngle;
import hmi.graphics.collada.FalloffExponent;
import hmi.graphics.collada.LinearAttenuation;
import hmi.graphics.collada.QuadraticAttenuation;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Spot
extends ColladaElement {
    private CommonColor color;
    private ConstantAttenuation constantAttenuation;
    private LinearAttenuation linearAttenuation;
    private QuadraticAttenuation quadraticAttenuation;
    private FalloffAngle falloffAngle;
    private FalloffExponent falloffExponent;
    private static final String XMLTAG = "spot";

    public Spot() {
    }

    public Spot(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.color);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.constantAttenuation);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.linearAttenuation);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.quadraticAttenuation);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.falloffAngle);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.falloffExponent);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(CommonColor.xmlTag())) {
                this.color = new CommonColor(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(ConstantAttenuation.xmlTag())) {
                this.constantAttenuation = new ConstantAttenuation(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(LinearAttenuation.xmlTag())) {
                this.linearAttenuation = new LinearAttenuation(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(QuadraticAttenuation.xmlTag())) {
                this.quadraticAttenuation = new QuadraticAttenuation(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(FalloffAngle.xmlTag())) {
                this.falloffAngle = new FalloffAngle(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(FalloffExponent.xmlTag())) {
                this.falloffExponent = new FalloffExponent(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Spot: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.color);
        this.addColladaNode(this.constantAttenuation);
        this.addColladaNode(this.linearAttenuation);
        this.addColladaNode(this.quadraticAttenuation);
        this.addColladaNode(this.falloffAngle);
        this.addColladaNode(this.falloffExponent);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

