/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Annotate;
import hmi.graphics.collada.Bind;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.CompilerOptions;
import hmi.graphics.collada.CompilerTarget;
import hmi.graphics.collada.Name;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Shader
extends ColladaElement {
    private String stage;
    private ArrayList<Annotate> annotateList = new ArrayList();
    private CompilerTarget compilerTarget;
    private Name name;
    private CompilerOptions compilerOptions;
    private ArrayList<Bind> bindList = new ArrayList();
    private static final String XMLTAG = "shader";

    public Shader() {
    }

    public Shader(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Shader.appendAttribute((StringBuilder)buf, (String)"stage", (String)this.stage);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.stage = this.getOptionalAttribute("stage", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Shader.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.annotateList);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.compilerTarget);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.name);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.compilerOptions);
        Shader.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.bindList);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Annotate.xmlTag())) {
                this.annotateList.add(new Annotate(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(CompilerTarget.xmlTag())) {
                this.compilerTarget = new CompilerTarget(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Name.xmlTag())) {
                this.name = new Name(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(CompilerOptions.xmlTag())) {
                this.compilerOptions = new CompilerOptions(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Bind.xmlTag())) {
                this.bindList.add(new Bind(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Shader: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.annotateList);
        this.addColladaNode(this.compilerTarget);
        this.addColladaNode(this.name);
        this.addColladaNode(this.compilerOptions);
        this.addColladaNodes(this.bindList);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

