/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Input;
import hmi.graphics.collada.Mesh;
import hmi.graphics.collada.P;
import hmi.graphics.collada.PH;
import hmi.graphics.collada.PrimitiveMeshElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Polygons
extends PrimitiveMeshElement {
    private ArrayList<P> plist = new ArrayList();
    private ArrayList<PH> phlist = new ArrayList();
    private int[] vcounts;
    private static final String XMLTAG = "polygons";

    public Polygons() {
        this.setMeshType(Mesh.MeshType.Polygons);
    }

    public Polygons(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
        this.setMeshType(Mesh.MeshType.Polygons);
    }

    public int[] getVCounts() {
        return this.vcounts;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Polygons.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.getInputs());
        Polygons.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.plist);
        Polygons.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.phlist);
        Polygons.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.getExtras());
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Input.xmlTag())) {
                Input inp = new Input(this.getCollada(), tokenizer);
                this.getInputs().add(inp);
                if (inp.getOffset() <= this.getMaxOffset()) continue;
                this.setMaxOffset(inp.getOffset());
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.getExtras().add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(P.xmlTag())) {
                this.plist.add(new P(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(PH.xmlTag())) {
                this.phlist.add(new PH(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Polygons: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.getInputs());
        this.addColladaNodes(this.plist);
        this.addColladaNodes(this.phlist);
        this.addColladaNodes(this.getExtras());
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    @Override
    public void createIndexArrays() {
        this.setNrOfOffsets(this.getMaxOffset() + 1);
        int indexArrayLength = 0;
        int pcount = 0;
        this.vcounts = new int[this.getCount()];
        for (P p : this.plist) {
            int plen = p.getIndices().length;
            if (plen % this.getNrOfOffsets() != 0) {
                this.getCollada().warning("Warning: Collada Polygon Mesh, createIndices: number of P indices (" + plen + ") for polygon " + pcount + " is not a multiple of the number of offsets (" + this.getNrOfOffsets() + ")");
            }
            int nrOfVerts = plen / this.getNrOfOffsets();
            indexArrayLength += nrOfVerts;
            this.vcounts[pcount] = nrOfVerts;
            ++pcount;
        }
        this.setIndexArrayLength(indexArrayLength);
        if (this.getCount() != pcount) {
            this.getCollada().warning("Warning: Collada Polygon Mesh, specified polygon count (" + this.getCount() + ") does not match actual number of polygons (" + pcount + ")");
        }
        this.allocateIndices(this.getNrOfOffsets(), this.getIndexArrayLength());
        int i = 0;
        int pi = 0;
        for (P p : this.plist) {
            int[] pindices = p.getIndices();
            int nrOfVerts = this.vcounts[pi];
            int noffsets = this.getNrOfOffsets();
            for (int vi = 0; vi < nrOfVerts; ++vi) {
                for (int indexOffset = 0; indexOffset < noffsets; ++indexOffset) {
                    int[] indices = this.getIndices(indexOffset);
                    indices[i] = pindices[vi * noffsets + indexOffset];
                }
                ++i;
            }
            ++pi;
        }
    }
}

