/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.AspectRatio;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.XFov;
import hmi.graphics.collada.XMag;
import hmi.graphics.collada.YFov;
import hmi.graphics.collada.ZFar;
import hmi.graphics.collada.ZNear;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Perspective
extends ColladaElement {
    private XFov xfov;
    private YFov yfov;
    private AspectRatio aspectRatio;
    private ZNear znear;
    private ZFar zfar;
    private static final String XMLTAG = "perspective";

    public Perspective(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.xfov);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.yfov);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.aspectRatio);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.znear);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.zfar);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(XMag.xmlTag())) {
                this.xfov = new XFov(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(YFov.xmlTag())) {
                this.yfov = new YFov(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(AspectRatio.xmlTag())) {
                this.aspectRatio = new AspectRatio(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(ZNear.xmlTag())) {
                this.znear = new ZNear(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(ZFar.xmlTag())) {
                this.zfar = new ZFar(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Perspective: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.xfov);
        this.addColladaNode(this.yfov);
        this.addColladaNode(this.aspectRatio);
        this.addColladaNode(this.znear);
        this.addColladaNode(this.zfar);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

