/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.TechniqueCommonLight;
import hmi.graphics.collada.TechniqueCore;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Light
extends ColladaElement {
    private Asset asset;
    private TechniqueCommonLight techniqueCommonLight;
    private ArrayList<TechniqueCore> techniques = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "light";

    public Light() {
    }

    public Light(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.techniqueCommonLight);
        Light.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.techniques);
        Light.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(TechniqueCommonLight.xmlTag())) {
                this.techniqueCommonLight = new TechniqueCommonLight(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(TechniqueCore.xmlTag())) {
                this.techniques.add(new TechniqueCore(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Light: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.asset);
        this.addColladaNode(this.techniqueCommonLight);
        this.addColladaNodes(this.techniques);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

