/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class InitFrom
extends ColladaElement {
    private String imageRef;
    private int mip = 0;
    private int slice = 0;
    private String face = null;
    private static final String XMLTAG = "init_from";

    public InitFrom() {
    }

    public InitFrom(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public String getImageId() {
        return this.imageRef;
    }

    public String getImageFile() {
        return this.imageRef;
    }

    public int getMip() {
        return this.mip;
    }

    public int getSlice() {
        return this.slice;
    }

    public String getFace() {
        return this.face;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        InitFrom.appendNewLine((StringBuilder)buf);
        InitFrom.appendSpaces((StringBuilder)buf, (XMLFormatting)fmt);
        InitFrom.appendTab((StringBuilder)buf);
        buf.append(this.imageRef);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        this.imageRef = tokenizer.takeCharData().trim();
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        if (this.mip > 0) {
            InitFrom.appendAttribute((StringBuilder)buf, (String)"mip", (int)this.mip);
        }
        if (this.slice > 0) {
            InitFrom.appendAttribute((StringBuilder)buf, (String)"slice", (int)this.slice);
        }
        if (this.face != null) {
            InitFrom.appendAttribute((StringBuilder)buf, (String)"face", (String)this.face);
        }
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.mip = this.getOptionalIntAttribute("height", attrMap, 0);
        this.slice = this.getOptionalIntAttribute("width", attrMap, 0);
        this.face = this.getOptionalAttribute("face", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

