/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.ColladaElement;
import hmi.util.Console;
import hmi.util.Resources;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Logger;

public class Include
extends ColladaElement {
    private String url = "";
    private Resources resources;
    private static Logger logger = Logger.getLogger("hmi.xml");
    private static final String XMLTAG = "include";

    public Include() {
    }

    public Include(Resources resources) {
        this();
        if (resources == null) {
            Console.println((String)"Collada include with null resources ");
        }
        this.resources = resources;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setFile(String resourceFileName) {
        this.url = resourceFileName;
    }

    public boolean switchReader(XMLTokenizer tokenizer) {
        if (this.url == null || this.url.length() == 0) {
            Console.println((String)"Collada include: null or empty url");
            return false;
        }
        if (this.resources == null) {
            Console.println((String)"Collada include: null Resources");
            return false;
        }
        BufferedReader reader = this.resources.getReader(this.url);
        tokenizer.pushReader(reader);
        tokenizer.setpopOnEndOfDocument(true);
        return true;
    }

    public void postProcess(XMLTokenizer tokenizer) {
        boolean switched = this.switchReader(tokenizer);
        if (!switched) {
            Console.println((String)"include: Could not switch input stream");
        }
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        super.appendAttributeString(buf);
        return buf;
    }

    public boolean decodeAttribute(String attrName, String valCode, XMLTokenizer tokenizer) {
        if (attrName.equals("url")) {
            String urlspec = valCode.trim();
            if (urlspec.length() == 0) {
                logger.warning("Empty URL at line " + tokenizer.getLine());
            } else {
                this.setURL(urlspec);
            }
            return true;
        }
        if (attrName.equals("file")) {
            String fileName = valCode.trim();
            if (fileName.length() == 0) {
                logger.warning("Empty file name at line " + tokenizer.getLine());
            } else {
                this.setFile(fileName);
            }
            return true;
        }
        return super.decodeAttribute(attrName, valCode, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

