/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Annotate;
import hmi.graphics.collada.Code;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Include;
import hmi.graphics.collada.Name;
import hmi.graphics.collada.Setparam;
import hmi.graphics.collada.ShaderInclude;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Generator
extends ColladaElement {
    private ArrayList<Annotate> annotateList = new ArrayList();
    private Code code;
    private ShaderInclude include;
    private Name name;
    private ArrayList<Setparam> setparamList = new ArrayList();
    private static final String XMLTAG = "generator";

    public Generator() {
    }

    public Generator(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Generator.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.annotateList);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.code);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.include);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.name);
        Generator.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.setparamList);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Annotate.xmlTag())) {
                this.annotateList.add(new Annotate(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Code.xmlTag())) {
                this.code = new Code(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Include.xmlTag())) {
                this.include = new ShaderInclude(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Name.xmlTag())) {
                this.name = new Name(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Setparam.xmlTag())) {
                this.setparamList.add(new Setparam(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Generator: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.annotateList);
        this.addColladaNode(this.code);
        this.addColladaNode(this.include);
        this.addColladaNode(this.name);
        this.addColladaNodes(this.setparamList);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

