/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Annotate;
import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ColladaImage;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Newparam;
import hmi.graphics.collada.ProfileCG;
import hmi.graphics.collada.ProfileCOMMON;
import hmi.graphics.collada.ProfileGLSL;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Effect
extends ColladaElement {
    private Asset asset;
    private ArrayList<Annotate> annotateList = new ArrayList();
    private ArrayList<ColladaImage> imageList = new ArrayList();
    private ArrayList<Newparam> newparamList = new ArrayList();
    private ArrayList<ProfileCOMMON> profileCommonList = new ArrayList();
    private ArrayList<ProfileCG> profileCGList = new ArrayList();
    private ArrayList<ProfileGLSL> profileGLSLList = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "effect";

    public Effect() {
    }

    public Effect(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public List<Newparam> getNewparamList() {
        return this.newparamList;
    }

    public List<ProfileCOMMON> getProfileCOMMONList() {
        return this.profileCommonList;
    }

    public List<ProfileGLSL> getProfileGLSLList() {
        return this.profileGLSLList;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        Effect.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.annotateList);
        Effect.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.imageList);
        Effect.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.newparamList);
        Effect.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.profileCommonList);
        Effect.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.profileCGList);
        Effect.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.profileGLSLList);
        Effect.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Annotate.xmlTag())) {
                this.annotateList.add(new Annotate(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(ColladaImage.xmlTag())) {
                this.imageList.add(new ColladaImage(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Newparam.xmlTag())) {
                this.newparamList.add(new Newparam(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(ProfileCOMMON.xmlTag())) {
                this.profileCommonList.add(new ProfileCOMMON(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(ProfileCG.xmlTag())) {
                this.profileCGList.add(new ProfileCG(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(ProfileGLSL.xmlTag())) {
                this.profileGLSLList.add(new ProfileGLSL(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Effect: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.asset);
        this.addColladaNodes(this.annotateList);
        this.addColladaNodes(this.imageList);
        this.addColladaNodes(this.newparamList);
        this.addColladaNodes(this.profileCommonList);
        this.addColladaNodes(this.profileCGList);
        this.addColladaNodes(this.profileGLSLList);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

