/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.FColladaProfile;
import hmi.graphics.collada.Max3DProfile;
import hmi.graphics.collada.MayaProfile;
import hmi.graphics.collada.RenderMonkeyProfile;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class CommonTexture
extends ColladaElement {
    private String sampler2D;
    private String texCoord = null;
    private Extra extra;
    private static final String XMLTAG = "texture";

    public CommonTexture() {
    }

    public CommonTexture(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.extra);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Extra.xmlTag())) {
                this.extra = new Extra(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("CommonTexture: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.extra);
    }

    public String getSampler2D() {
        return this.sampler2D;
    }

    public String getTexCoord() {
        return this.texCoord;
    }

    public Max3DProfile getMax3DProfile() {
        return this.extra == null ? null : this.extra.getMax3DProfile();
    }

    public FColladaProfile getFColladaProfile() {
        return this.extra == null ? null : this.extra.getFColladaProfile();
    }

    public MayaProfile getMayaProfile() {
        return this.extra == null ? null : this.extra.getMayaProfile();
    }

    public RenderMonkeyProfile getRenderMonkeyProfileProfile() {
        return this.extra == null ? null : this.extra.getRenderMonkeyProfileProfile();
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        CommonTexture.appendAttribute((StringBuilder)buf, (String)XMLTAG, (String)this.sampler2D);
        CommonTexture.appendAttribute((StringBuilder)buf, (String)"texCoord", (String)this.texCoord);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.sampler2D = this.getRequiredAttribute(XMLTAG, attrMap, tokenizer);
        this.texCoord = this.getRequiredAttribute("texcoord", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

