/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Input;
import hmi.graphics.collada.Source;
import hmi.graphics.collada.V;
import hmi.graphics.collada.VCount;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ColladaVertexWeights
extends ColladaElement {
    private ArrayList<Input> inputs = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList(2);
    private V v;
    private VCount vcount;
    private int count;
    private String[] jointNames = null;
    private String jointSourceId = null;
    private String weightSourceId = null;
    private float[] indexedWeights;
    private float[] jointWeights;
    private int[] jointIndices;
    private int stride;
    private int jointOffset;
    private int weightOffset;
    private int indexLen;
    private boolean resolved = false;
    private static final String XMLTAG = "vertex_weights";

    public ColladaVertexWeights() {
    }

    public ColladaVertexWeights(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public void resolve() {
        this.resolved = true;
        for (Input inp : this.inputs) {
            if (inp.getSemantic().equals("JOINT")) {
                this.jointSourceId = this.urlToId(inp.getSource());
            }
            if (!inp.getSemantic().equals("WEIGHT")) continue;
            this.weightSourceId = this.urlToId(inp.getSource());
        }
        if (this.jointSourceId == null) {
            throw new RuntimeException("<vertex_weights> element: no <input> with JOINT semantic specified");
        }
        Source jointSource = this.getCollada().getSource(this.jointSourceId);
        this.jointNames = jointSource.getHomogeneousNameData();
        if (this.weightSourceId == null) {
            throw new RuntimeException("<vertex_weights> element: no <input> with WEIGHT semantic specified");
        }
        Source weightSource = this.getCollada().getSource(this.weightSourceId);
        this.indexedWeights = weightSource.getHomogeneousFloatData();
    }

    public String[] getJointNames() {
        if (this.jointNames == null) {
            this.resolve();
        }
        return this.jointNames;
    }

    public int[] getJointIndices() {
        if (!this.resolved) {
            this.resolve();
        }
        this.jointIndices = new int[this.indexLen];
        for (int i = 0; i < this.indexLen; ++i) {
            this.jointIndices[i] = this.v.getIndex(this.jointOffset + this.stride * i);
        }
        return this.jointIndices;
    }

    public float[] getJointWeights() {
        if (!this.resolved) {
            this.resolve();
        }
        this.jointWeights = new float[this.indexLen];
        for (int i = 0; i < this.indexLen; ++i) {
            this.jointWeights[i] = this.indexedWeights[this.v.getIndex(this.weightOffset + this.stride * i)];
        }
        return this.jointWeights;
    }

    public int[] getVCount() {
        return this.vcount.getCounts();
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        ColladaVertexWeights.appendAttribute((StringBuilder)buf, (String)"count", (int)this.count);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.count = this.getRequiredIntAttribute("count", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        ColladaVertexWeights.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.inputs);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.vcount);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.v);
        ColladaVertexWeights.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        int maxOffset = 0;
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Input.xmlTag())) {
                String sem;
                Input inp = new Input(this.getCollada(), tokenizer);
                this.inputs.add(inp);
                if (inp.getOffset() > maxOffset) {
                    maxOffset = inp.getOffset();
                }
                if ((sem = inp.getSemantic()).equals("JOINT")) {
                    this.jointOffset = inp.getOffset();
                    continue;
                }
                if (sem.equals("WEIGHT")) {
                    this.weightOffset = inp.getOffset();
                    continue;
                }
                this.getCollada().warning("Vertex_weights, unknown input semantics: " + sem);
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(VCount.xmlTag())) {
                this.vcount = new VCount(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(V.xmlTag())) {
                this.v = new V(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("ColladaVertexWeights: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.inputs);
        this.addColladaNodes(this.extras);
        this.addColladaNode(this.vcount);
        this.addColladaNode(this.v);
        this.stride = maxOffset + 1;
        this.indexLen = this.v.getNrIndices() / this.stride;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

