/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Animation;
import hmi.graphics.collada.AnimationClip;
import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Camera;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ColladaImage;
import hmi.graphics.collada.Controller;
import hmi.graphics.collada.Effect;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.ForceField;
import hmi.graphics.collada.Geometry;
import hmi.graphics.collada.Include;
import hmi.graphics.collada.Library;
import hmi.graphics.collada.LibraryAnimationClips;
import hmi.graphics.collada.LibraryAnimations;
import hmi.graphics.collada.LibraryCameras;
import hmi.graphics.collada.LibraryControllers;
import hmi.graphics.collada.LibraryEffects;
import hmi.graphics.collada.LibraryForceFields;
import hmi.graphics.collada.LibraryGeometries;
import hmi.graphics.collada.LibraryImages;
import hmi.graphics.collada.LibraryLights;
import hmi.graphics.collada.LibraryMaterials;
import hmi.graphics.collada.LibraryNodes;
import hmi.graphics.collada.LibraryPhysicsMaterials;
import hmi.graphics.collada.LibraryPhysicsModels;
import hmi.graphics.collada.LibraryPhysicsScenes;
import hmi.graphics.collada.LibraryVisualScenes;
import hmi.graphics.collada.Light;
import hmi.graphics.collada.Material;
import hmi.graphics.collada.Node;
import hmi.graphics.collada.PhysicsMaterial;
import hmi.graphics.collada.PhysicsModel;
import hmi.graphics.collada.PhysicsScene;
import hmi.graphics.collada.Scene;
import hmi.graphics.collada.Source;
import hmi.graphics.collada.VisualScene;
import hmi.util.Resources;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Collada
extends ColladaElement {
    private static List<String> supportedVersion = new ArrayList<String>();
    private String specifiedVersion = "";
    private String xmlns = "http://www.collada.org/2005/11/COLLADASchema";
    private Asset asset;
    private Scene scene;
    private List<Library<Animation>> librariesAnimations = new ArrayList<Library<Animation>>(2);
    private List<Library<AnimationClip>> librariesAnimationClips = new ArrayList<Library<AnimationClip>>(2);
    private List<Library<Camera>> librariesCameras = new ArrayList<Library<Camera>>(2);
    private List<Library<Controller>> librariesControllers = new ArrayList<Library<Controller>>(2);
    private List<Library<Effect>> librariesEffects = new ArrayList<Library<Effect>>(2);
    private List<Library<ForceField>> librariesForceFields = new ArrayList<Library<ForceField>>(2);
    private List<Library<Geometry>> librariesGeometries = new ArrayList<Library<Geometry>>(2);
    private List<Library<ColladaImage>> librariesImages = new ArrayList<Library<ColladaImage>>(2);
    private List<Library<Light>> librariesLights = new ArrayList<Library<Light>>(2);
    private List<Library<Material>> librariesMaterials = new ArrayList<Library<Material>>(2);
    private List<Library<Node>> librariesNodes = new ArrayList<Library<Node>>(2);
    private List<Library<PhysicsMaterial>> librariesPhysicsMaterials = new ArrayList<Library<PhysicsMaterial>>(2);
    private List<Library<PhysicsModel>> librariesPhysicsModels = new ArrayList<Library<PhysicsModel>>(2);
    private List<Library<PhysicsScene>> librariesPhysicsScenes = new ArrayList<Library<PhysicsScene>>(2);
    private List<Library<VisualScene>> librariesVisualScenes = new ArrayList<Library<VisualScene>>(2);
    private Extra extra;
    public static final int FLOAT = 1;
    public static final int INT = 2;
    public static final int BOOL = 3;
    public static final int NAME = 4;
    public static final int IDREF = 5;
    private Map<String, Integer> arrayTypes = new HashMap<String, Integer>();
    private Map<String, float[]> floatArrays = new HashMap<String, float[]>();
    private Map<String, int[]> intArrays = new HashMap<String, int[]>();
    private Map<String, boolean[]> boolArrays = new HashMap<String, boolean[]>();
    private Map<String, String[]> nameArrays = new HashMap<String, String[]>();
    private Map<String, String[]> idrefArrays = new HashMap<String, String[]>();
    private Map<String, Source> sources = new HashMap<String, Source>();
    private Resources resources = null;
    private static final String XMLTAG = "COLLADA";
    private Logger logger = Logger.getLogger("hmi.graphics.collada");

    public List<Library<Animation>> getLibrariesAnimations() {
        return this.librariesAnimations;
    }

    public List<Library<AnimationClip>> getLibrariesAnimationClips() {
        return this.librariesAnimationClips;
    }

    public List<Library<Camera>> getLibrariesCameras() {
        return this.librariesCameras;
    }

    public List<Library<Controller>> getLibrariesControllers() {
        return this.librariesControllers;
    }

    public List<Library<Effect>> getLibrariesEffects() {
        return this.librariesEffects;
    }

    public List<Library<ForceField>> getLibrariesForceFields() {
        return this.librariesForceFields;
    }

    public List<Library<Geometry>> getLibrariesGeometries() {
        return this.librariesGeometries;
    }

    public List<Library<ColladaImage>> getLibrariesImages() {
        return this.librariesImages;
    }

    public List<Library<Light>> getLibrariesLights() {
        return this.librariesLights;
    }

    public List<Library<Material>> getLibrariesMaterials() {
        return this.librariesMaterials;
    }

    public List<Library<Node>> getLibrariesNodes() {
        return this.librariesNodes;
    }

    public List<Library<PhysicsMaterial>> getLibrariesPhysicsMaterials() {
        return this.librariesPhysicsMaterials;
    }

    public List<Library<PhysicsModel>> getLibrariesPhysicsModels() {
        return this.librariesPhysicsModels;
    }

    public List<Library<PhysicsScene>> getLibrariesPhysicsScenes() {
        return this.librariesPhysicsScenes;
    }

    public List<Library<VisualScene>> getLibrariesVisualScenes() {
        return this.librariesVisualScenes;
    }

    public Scene getScene() {
        return this.scene;
    }

    public Collada() {
    }

    public Collada(XMLTokenizer tokenizer) throws IOException {
        this.setCollada(this);
        this.resources = null;
        this.readXML(tokenizer);
    }

    public Collada(XMLTokenizer tokenizer, Resources resources) throws IOException {
        this.setCollada(this);
        this.resources = resources;
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesAnimations);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesAnimationClips);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesCameras);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesControllers);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesEffects);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesForceFields);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesGeometries);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesImages);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesLights);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesMaterials);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesNodes);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesPhysicsMaterials);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesPhysicsModels);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesPhysicsScenes);
        Collada.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.librariesVisualScenes);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.scene);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        this.asset = new Asset(this.getCollada(), tokenizer);
        this.addColladaNode(this.asset);
        boolean sceneReached = false;
        Collada collada = this.getCollada();
        while (tokenizer.atSTag() && !sceneReached) {
            String tag = tokenizer.getTagName();
            if (tag.equals(LibraryAnimations.xmlTag())) {
                this.librariesAnimations.add(new LibraryAnimations(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryAnimationClips.xmlTag())) {
                this.librariesAnimationClips.add(new LibraryAnimationClips(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryCameras.xmlTag())) {
                this.librariesCameras.add(new LibraryCameras(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryControllers.xmlTag())) {
                this.librariesControllers.add(new LibraryControllers(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryEffects.xmlTag())) {
                this.librariesEffects.add(new LibraryEffects(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryForceFields.xmlTag())) {
                this.librariesForceFields.add(new LibraryForceFields(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryGeometries.xmlTag())) {
                this.librariesGeometries.add(new LibraryGeometries(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryImages.xmlTag())) {
                this.librariesImages.add(new LibraryImages(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryLights.xmlTag())) {
                this.librariesLights.add(new LibraryLights(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryMaterials.xmlTag())) {
                this.librariesMaterials.add(new LibraryMaterials(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryNodes.xmlTag())) {
                this.librariesNodes.add(new LibraryNodes(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryPhysicsMaterials.xmlTag())) {
                this.librariesPhysicsMaterials.add(new LibraryPhysicsMaterials(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryPhysicsModels.xmlTag())) {
                this.librariesPhysicsModels.add(new LibraryPhysicsModels(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryPhysicsScenes.xmlTag())) {
                this.librariesPhysicsScenes.add(new LibraryPhysicsScenes(collada, tokenizer));
                continue;
            }
            if (tag.equals(LibraryVisualScenes.xmlTag())) {
                this.librariesVisualScenes.add(new LibraryVisualScenes(collada, tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extra = new Extra(collada, tokenizer);
                continue;
            }
            if (tag.equals(Scene.xmlTag())) {
                sceneReached = true;
                this.scene = new Scene(collada, tokenizer);
                continue;
            }
            if (tag.equals(Include.xmlTag())) {
                Include include = new Include(this.resources);
                include.readXML(tokenizer);
                continue;
            }
            this.warning(tokenizer.getErrorMessage("Collada: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.librariesAnimations);
        this.addColladaNodes(this.librariesAnimationClips);
        this.addColladaNodes(this.librariesCameras);
        this.addColladaNodes(this.librariesControllers);
        this.addColladaNodes(this.librariesEffects);
        this.addColladaNodes(this.librariesForceFields);
        this.addColladaNodes(this.librariesGeometries);
        this.addColladaNodes(this.librariesImages);
        this.addColladaNodes(this.librariesLights);
        this.addColladaNodes(this.librariesMaterials);
        this.addColladaNodes(this.librariesNodes);
        this.addColladaNodes(this.librariesPhysicsMaterials);
        this.addColladaNodes(this.librariesPhysicsModels);
        this.addColladaNodes(this.librariesPhysicsScenes);
        this.addColladaNodes(this.librariesVisualScenes);
        this.addColladaNode(this.extra);
        this.addColladaNode(this.scene);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Collada.appendAttribute((StringBuilder)buf, (String)"xmlns", (String)this.xmlns);
        Collada.appendAttribute((StringBuilder)buf, (String)"version", (String)this.specifiedVersion);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String specifiedXmlns;
        this.specifiedVersion = this.getRequiredAttribute("version", attrMap, tokenizer);
        boolean recognizedVersion = false;
        for (String version : supportedVersion) {
            if (!this.specifiedVersion.equals(version)) continue;
            recognizedVersion = true;
        }
        if (!recognizedVersion) {
            this.logger.warning("Collada: unrecognized specified version: " + this.specifiedVersion);
        }
        if ((specifiedXmlns = this.getOptionalAttribute("xmlns", attrMap)) != null && !specifiedXmlns.equals(this.xmlns)) {
            this.logger.warning("Collada: unknown/unexpected xmlns: " + specifiedXmlns);
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public <X extends ColladaElement> X getLibItem(List<Library<X>> libList, String url) {
        String id;
        String string = id = url.charAt(0) == '#' ? url.substring(1) : url;
        if (libList.size() == 0) {
            this.warning("Collada.getLibItem: No library for " + url);
        }
        for (Library<X> lib : libList) {
            X libItem = lib.getLibItem(id);
            if (libItem == null) continue;
            return libItem;
        }
        return null;
    }

    public void addFloatArray(String id, float[] floats) {
        if (id == null) {
            throw new RuntimeException("Collada.addFloatArray with null id");
        }
        if (floats == null) {
            throw new RuntimeException("Collada.addFloatArray " + id + " with null floats");
        }
        this.floatArrays.put(id, floats);
        this.arrayTypes.put(id, 1);
    }

    public float[] getFloatArray(String id) {
        return this.floatArrays.get(id);
    }

    public void addIntArray(String id, int[] ints) {
        if (id == null) {
            throw new RuntimeException("Collada.addIntArray with null id");
        }
        if (ints == null) {
            throw new RuntimeException("Collada.addIntArray " + id + " with null ints");
        }
        this.intArrays.put(id, ints);
        this.arrayTypes.put(id, 2);
    }

    public int[] getIntArray(String id) {
        return this.intArrays.get(id);
    }

    public void addBoolArray(String id, boolean[] bools) {
        if (id == null) {
            throw new RuntimeException("Collada.addBoolArray with null id");
        }
        if (bools == null) {
            throw new RuntimeException("Collada.addBoolArray " + id + " with null bools");
        }
        this.boolArrays.put(id, bools);
        this.arrayTypes.put(id, 3);
    }

    public boolean[] getBoolArray(String id) {
        return this.boolArrays.get(id);
    }

    public void addNameArray(String id, String[] names) {
        if (id == null) {
            throw new RuntimeException("Collada.addNameArray with null id");
        }
        if (names == null) {
            throw new RuntimeException("Collada.addNameArray " + id + " with null names");
        }
        this.nameArrays.put(id, names);
        this.arrayTypes.put(id, 4);
    }

    public String[] getNameArray(String id) {
        return this.nameArrays.get(id);
    }

    public void addIDREFArray(String id, String[] idrefs) {
        if (id == null) {
            throw new RuntimeException("Collada.addIDREFArray with null id");
        }
        if (idrefs == null) {
            throw new RuntimeException("Collada.addIDREFArray " + id + " with null idrefs");
        }
        this.idrefArrays.put(id, idrefs);
        this.arrayTypes.put(id, 5);
    }

    public String[] getIDREFArray(String id) {
        return this.idrefArrays.get(id);
    }

    public int getArrayType(String id) {
        Integer res = this.arrayTypes.get(id);
        return res == null ? 0 : res;
    }

    public void addSource(String id, Source source) {
        if (id == null) {
            this.logger.warning("addSource with null id");
        } else {
            Source prev = this.sources.put(id, source);
            if (prev != null) {
                this.logger.severe("addSource for " + id + " overwrites previous data");
            }
        }
    }

    public Source getSource(String id) {
        return this.sources.get(id);
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void severe(String msg) {
        this.logger.severe(msg);
    }

    public void warning(String msg) {
        this.logger.warning(msg);
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    static {
        supportedVersion.add("1.4.0");
        supportedVersion.add("1.4.1");
    }
}

