/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.ScenegraphTranslator;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.util.DaeHumanoidLoader;
import hmi.graphics.util.SceneIO;
import java.io.IOException;

public final class SegmentedDaeHumanoidLoader
implements DaeHumanoidLoader {
    private VGLNode avatarRenderNode;
    private VJoint avatarAnimationRootJoint;
    private GLScene glScene;
    private GScene gscene;

    @Override
    public VJoint getAvatarAnimationRootJoint() {
        return this.avatarAnimationRootJoint;
    }

    @Override
    public VGLNode getAvatarRenderNode() {
        return this.avatarRenderNode;
    }

    @Override
    public GLScene getGLScene() {
        return this.glScene;
    }

    public SegmentedDaeHumanoidLoader(String id, String colladaResourceDir, String colladaFileName, String jointRenamingFileName, float scale, boolean setToHAnim) throws IOException {
        this.gscene = SceneIO.readGScene(colladaResourceDir, colladaFileName, setToHAnim ? "BLUEGUY" : "NONE");
        this.glScene = ScenegraphTranslator.fromGSceneToGLScene(this.gscene);
        this.avatarAnimationRootJoint = this.gscene.getPartBySid("HumanoidRoot").getVJoint();
        this.renameRoot(id, this.avatarAnimationRootJoint);
        this.avatarRenderNode = new VGLNode(this.avatarAnimationRootJoint, this.glScene.getGLShapeList());
        this.afterLoad();
    }

    private void renameRoot(String id, VJoint avatarAnimationRootJoint) {
        avatarAnimationRootJoint.setId("HumanoidRoot_" + id);
        avatarAnimationRootJoint.setSid("HumanoidRoot");
        avatarAnimationRootJoint.setName("The HumanoidRoot " + id);
    }

    private void afterLoad() {
        GLShape state = new GLShape();
        state.addGLState(new GLFill());
        this.avatarRenderNode.getGLShapeList().prepend(state);
    }
}

