/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.ScenegraphTranslator;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.util.SceneIO;
import java.io.IOException;

public final class HumanoidLoader {
    private VJoint avatarAnimationRootJoint;
    private VGLNode avatarRenderNode;
    private GLScene glScene;
    private GScene gscene;

    public GScene getGScene() {
        return this.gscene;
    }

    public VJoint getAvatarAnimationRootJoint() {
        return this.avatarAnimationRootJoint;
    }

    public VGLNode getAvatarRenderNode() {
        return this.avatarRenderNode;
    }

    public GLScene getGLScene() {
        return this.glScene;
    }

    public HumanoidLoader(String id, String resourceDir, String fileName, String postProcessing) throws IOException {
        this.gscene = SceneIO.readGScene(resourceDir, fileName, postProcessing);
        this.glScene = ScenegraphTranslator.fromGSceneToGLScene(this.gscene);
        this.avatarAnimationRootJoint = this.glScene.getVJoint("HumanoidRoot");
        this.renameRoot(id);
        this.avatarRenderNode = new VGLNode(this.avatarAnimationRootJoint, this.glScene.getGLShapeList());
        this.afterLoad();
    }

    public HumanoidLoader(String id, String resourceDir, String fileName) throws IOException {
        this(id, resourceDir, fileName, "NONE");
    }

    private void renameRoot(String id) {
        this.avatarAnimationRootJoint.setId("HumanoidRoot_" + id);
        this.avatarAnimationRootJoint.setSid("HumanoidRoot");
        this.avatarAnimationRootJoint.setName("The HumanoidRoot " + id);
    }

    private void afterLoad() {
        GLShape state = new GLShape();
        state.addGLState(new GLFill());
        this.avatarRenderNode.getGLShapeList().prepend(state);
    }
}

