/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public final class BufferUtil {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    private BufferUtil() {
    }

    public static FloatBuffer directFloatBuffer(int numElements) {
        ByteBuffer bb = ByteBuffer.allocateDirect(numElements * 4);
        bb.order(ByteOrder.nativeOrder());
        return bb.asFloatBuffer();
    }

    public static FloatBuffer directFloatBuffer(float[] a) {
        ByteBuffer bb = ByteBuffer.allocateDirect(a.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(a);
        fb.rewind();
        return fb;
    }

    public static IntBuffer directIntBuffer(int numElements) {
        ByteBuffer bb = ByteBuffer.allocateDirect(numElements * 4);
        bb.order(ByteOrder.nativeOrder());
        return bb.asIntBuffer();
    }

    public static IntBuffer directIntBuffer(int[] a) {
        ByteBuffer bb = ByteBuffer.allocateDirect(a.length * 4);
        bb.order(ByteOrder.nativeOrder());
        IntBuffer ib = bb.asIntBuffer();
        ib.put(a);
        ib.rewind();
        return ib;
    }

    public static ShortBuffer directShortBuffer(int numElements) {
        ByteBuffer bb = ByteBuffer.allocateDirect(numElements * 2);
        bb.order(ByteOrder.nativeOrder());
        return bb.asShortBuffer();
    }

    public static ByteBuffer directByteBuffer(int numElements) {
        ByteBuffer bb = ByteBuffer.allocateDirect(numElements);
        return bb;
    }

    public static IntBuffer intBuffer(int[] a) {
        IntBuffer buf = BufferUtil.directIntBuffer(a.length);
        buf.put(a);
        buf.rewind();
        return buf;
    }

    public static FloatBuffer floatBuffer(float[] a) {
        FloatBuffer buf = BufferUtil.directFloatBuffer(a.length);
        buf.put(a);
        buf.rewind();
        return buf;
    }

    public static ShortBuffer shortBuffer(short[] a) {
        ShortBuffer buf = BufferUtil.directShortBuffer(a.length);
        buf.put(a);
        buf.rewind();
        return buf;
    }

    public static ByteBuffer byteBuffer(byte[] a) {
        ByteBuffer buf = BufferUtil.directByteBuffer(a.length);
        buf.put(a);
        buf.rewind();
        return buf;
    }

    public static ByteBuffer byteBuffer(String s) {
        ByteBuffer buf = BufferUtil.directByteBuffer(s.length());
        buf.put(s.getBytes());
        buf.rewind();
        return buf;
    }

    public static ByteBuffer stringToNullTerminatedByteBuffer(String s) {
        int len = s.length() + 1;
        ByteBuffer buf = BufferUtil.directByteBuffer(len);
        buf.put(s.getBytes());
        buf.put((byte)0);
        buf.flip();
        return buf;
    }

    public static String toString(ByteBuffer buf, int len) {
        byte[] bytes = new byte[len];
        buf.get(bytes);
        return new String(bytes);
    }

    public static String toString(ByteBuffer buf) {
        byte[] bytes = new byte[buf.limit()];
        buf.get(bytes);
        return new String(bytes);
    }
}

