/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.animation.ConfigList;
import hmi.animation.SkeletonInterpolator;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.Scene;
import hmi.graphics.collada.scenegraph.ColladaTranslator;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.xml.XMLTokenizer;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationConverter {
    private String[] jointSIDs;
    private int[] parentIndex;
    private float[][] inverseBindMatrices;
    private float[][] originalInverseBindMatrices;
    private static Logger logger = LoggerFactory.getLogger((String)AnimationConverter.class.getName());

    public AnimationConverter(String resourceDir, String resourceFileName) {
        this.readSkeletonAdaptationData(resourceDir, resourceFileName);
    }

    private void readSkeletonAdaptationData(String resourceDir, String resourceFileName) {
        String resDir = resourceDir == null || resourceDir.equals("") ? "" : resourceDir.replace('\\', '/') + "/";
        String file = resDir + resourceFileName;
        try {
            if (file.endsWith(".dae") || file.endsWith(".DAE")) {
                Collada col = Collada.forResource(file);
                if (col == null) {
                    throw new RuntimeException("AnimationConverter: null Collada input");
                }
                this.getSkeletonAdaptationData(col);
            } else {
                logger.error("AnimationConverter: scene file must be a Collada dae file");
            }
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    private void getSkeletonAdaptationData(Collada collada) {
        Scene scene = collada.getScene();
        if (scene == null) {
            throw new RuntimeException("AnimationConverter: Collada document without scene.");
        }
        GScene gscene = ColladaTranslator.colladaSceneToGScene(collada, scene);
        gscene.collectSkinnedMeshes();
        gscene.resolveSkinnedMeshJoints();
        HashMap<String, String> renaming = new HashMap();
        String upAxis = collada.getAsset().getUpAxis();
        if (upAxis.equals("X_UP")) {
            gscene.rotate(0.0f, 0.0f, 1.0f, 1.5707964f);
        } else if (!upAxis.equals("Y_UP") && !upAxis.equals("")) {
            if (upAxis.equals("Z_UP")) {
                gscene.rotate(1.0f, 0.0f, 0.0f, -1.5707964f);
            } else {
                logger.error("ColladaTranslator: Collada Asset with unknown or incorrect UP axis: " + upAxis);
            }
        }
        float scale = collada.getAsset().getUnitMeter();
        if (scale != 1.0f) {
            gscene.scale(scale);
        }
        GSkinnedMesh gmesh = gscene.getSkinnedMeshes().get(0);
        this.inverseBindMatrices = gmesh.getInvBindMatrices();
        this.originalInverseBindMatrices = new float[this.inverseBindMatrices.length][16];
        for (int i = 0; i < this.inverseBindMatrices.length; ++i) {
            Mat4f.set((float[])this.originalInverseBindMatrices[i], (float[])this.inverseBindMatrices[i]);
        }
        gmesh.simplifyBindPose();
        String renamingList = collada.getRenamingList();
        if (renamingList != null) {
            renaming = ColladaTranslator.getColladaRenaming(renamingList, gscene.getRootNodes());
            gscene.renameJoints(renaming);
        }
        gscene.setSkeletonHAnimPoses();
        this.jointSIDs = gmesh.getJointSIDs();
        this.parentIndex = gmesh.getParentIndex();
        this.inverseBindMatrices = gmesh.getInvBindMatrices();
    }

    public SkeletonInterpolator adaptSkeletonInterpolator(SkeletonInterpolator skel) {
        ConfigList configs = skel.getConfigList();
        int configSize = configs.getConfigSize();
        String configType = skel.getConfigType();
        String[] partIds = skel.getPartIds();
        int nrOfParts = partIds.length;
        float[][] origBindParentMat = new float[nrOfParts][16];
        float[][] origInvBindMat = new float[nrOfParts][];
        float[][] origBindParentQuat = new float[nrOfParts][4];
        float[][] origInvBindQuat = new float[nrOfParts][4];
        float[] Aquat = Quat4f.getQuat4fFromAxisAngleDegrees((float)1.0f, (float)0.0f, (float)0.0f, (float)-90.0f);
        float[] invAquat = Quat4f.getQuat4fFromAxisAngleDegrees((float)1.0f, (float)0.0f, (float)0.0f, (float)90.0f);
        float[][] bindMat = new float[nrOfParts][16];
        float[][] invBindParentMat = new float[nrOfParts][16];
        float[][] bindQuat = new float[nrOfParts][4];
        float[][] invBindParentQuat = new float[nrOfParts][4];
        for (int pi = 0; pi < nrOfParts; ++pi) {
            String pid = partIds[pi];
            for (int ji = 0; ji < this.jointSIDs.length; ++ji) {
                if (!this.jointSIDs[ji].equals(pid)) continue;
                origInvBindMat[pi] = this.originalInverseBindMatrices[ji];
                Quat4f.setFromMat4f((float[])origInvBindQuat[pi], (float[])origInvBindMat[pi]);
                int parIndex = this.parentIndex[ji];
                float[] origInvBindParent = null;
                if (parIndex >= 0) {
                    origInvBindParent = this.originalInverseBindMatrices[parIndex];
                    invBindParentMat[pi] = this.inverseBindMatrices[parIndex];
                } else {
                    origInvBindParent = Mat4f.getIdentity();
                    invBindParentMat[pi] = Mat4f.getIdentity();
                }
                Mat4f.invertAffine((float[])origBindParentMat[pi], (float[])origInvBindParent);
                Quat4f.setFromMat4f((float[])origBindParentQuat[pi], (float[])origBindParentMat[pi]);
                Quat4f.setFromMat4f((float[])invBindParentQuat[pi], (float[])invBindParentMat[pi]);
                Mat4f.invertAffine((float[])bindMat[pi], (float[])this.inverseBindMatrices[ji]);
                Quat4f.setFromMat4f((float[])bindQuat[pi], (float[])bindMat[pi]);
            }
        }
        int nrOfJoints = configSize / 4;
        if (nrOfJoints != nrOfParts) {
            logger.error("GLSkinnedMesh.adaptSkeletonInterpolator: nrOfParts differs from nrOfJoints");
        }
        int offset = configType.equals("T1R") ? 3 : 0;
        int stride = 4;
        float[] q = Quat4f.getQuat4f();
        float[] newq = Quat4f.getQuat4f();
        ConfigList adapted = new ConfigList(configSize);
        for (int ci = 0; ci < configs.size(); ++ci) {
            float[] cfg = configs.getConfig(ci);
            float[] newcfg = new float[configSize];
            for (int pi = 0; pi < nrOfJoints; ++pi) {
                q[0] = cfg[offset + stride * pi];
                q[1] = cfg[offset + stride * pi + 1];
                q[2] = cfg[offset + stride * pi + 2];
                q[3] = cfg[offset + stride * pi + 3];
                Quat4f.mul((float[])newq, (float[])Aquat, (float[])q);
                Quat4f.mul((float[])newq, (float[])newq, (float[])invAquat);
                Quat4f.mul((float[])newq, (float[])origBindParentQuat[pi], (float[])newq);
                Quat4f.mul((float[])newq, (float[])newq, (float[])origInvBindQuat[pi]);
                Quat4f.mul((float[])newq, (float[])invBindParentQuat[pi], (float[])newq);
                Quat4f.mul((float[])newq, (float[])newq, (float[])bindQuat[pi]);
                newcfg[offset + stride * pi] = newq[0];
                newcfg[offset + stride * pi + 1] = newq[1];
                newcfg[offset + stride * pi + 2] = newq[2];
                newcfg[offset + stride * pi + 3] = newq[3];
            }
            adapted.addConfig(configs.getTime(ci), newcfg);
        }
        SkeletonInterpolator result = new SkeletonInterpolator(skel.getPartIds(), adapted, skel.getConfigType());
        return result;
    }

    public void convertSkeletonInterpolator(String resourceDir, String skeletonInterpolatorFileName, String convertedInterpolatorFileName) {
        String resDir = resourceDir == null || resourceDir.equals("") ? "" : resourceDir.replace('\\', '/') + "/";
        String infileName = resDir + skeletonInterpolatorFileName;
        String outfile = resDir + convertedInterpolatorFileName;
        try {
            File inFile = new File(infileName);
            XMLTokenizer tk = new XMLTokenizer(inFile);
            SkeletonInterpolator ski = new SkeletonInterpolator(tk);
            SkeletonInterpolator adaptedSki = this.adaptSkeletonInterpolator(ski);
            PrintWriter out = new PrintWriter(outfile);
            int tab = 3;
            adaptedSki.writeXML(out, tab);
            out.close();
        }
        catch (Exception e) {
            logger.error("AnimationConvertor: " + e);
        }
    }

    public static void main(String[] arg) {
        String humanoidResources = "Humanoids/armandia/dae";
        String colladafile = "armandia-toplevel.dae";
        String infile = "";
        String outfile = "";
        switch (arg.length) {
            case 1: {
                infile = arg[0];
                outfile = "converted-" + infile;
                break;
            }
            case 2: {
                infile = arg[0];
                outfile = arg[1];
                break;
            }
            default: {
                System.out.println("provide conversion arguments:  <SkeletonInterpolator file> [<output file>] ");
                System.exit(0);
            }
        }
        logger.info("AnimationConvertor for  " + colladafile + ", converting " + infile + " to " + outfile);
        AnimationConverter converter = new AnimationConverter(humanoidResources, colladafile);
        converter.convertSkeletonInterpolator(null, infile, outfile);
        System.out.println("Conversion finished");
    }
}

