/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.math.Vec4f;
import hmi.util.BinUtil;
import hmi.util.BinaryExternalizable;
import hmi.util.Diff;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexWeights
extends XMLStructureAdapter
implements BinaryExternalizable,
Diff.Differentiable {
    private String name = "vertexweights";
    private int[] jcount;
    private int[] jointIndices;
    private float[] jointWeights;
    private int[] offsets;
    private static Logger logger = LoggerFactory.getLogger((String)VertexWeights.class.getName());
    private static final float DEFAULT_EPSMIN = 0.1f;
    private static final float DEFAULT_EPSPLUS = 0.05f;
    private static final int JCOUNTSPERLINE = 60;
    private static final int INDICESPERLINE = 60;
    private static final int WEIGHTSPERLINE = 30;
    private static final String XMLTAG = "vertexweights";

    public VertexWeights() {
    }

    public VertexWeights(int[] jcount, int[] jointIndices, float[] jointWeights) {
        this.jcount = jcount;
        this.jointIndices = jointIndices;
        this.jointWeights = jointWeights;
        this.offsets = new int[jcount.length];
        this.calculateOffsets();
    }

    public VertexWeights(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public String showDiff(Object vwObject) {
        VertexWeights vw = (VertexWeights)((Object)vwObject);
        if (vw == null) {
            return "VertexWeights " + this.name + ", diff: null VertexWeights";
        }
        String diff = Diff.showDiff((String)"VertexWeights", (String)this.name, (String)vw.name);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("VertexWeights " + this.name + ", diff jcount"), (int[])this.jcount, (int[])vw.jcount);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("VertexWeights " + this.name + ", diff jointIndices"), (int[])this.jointIndices, (int[])vw.jointIndices);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("VertexWeights " + this.name + ", diff jointWeights"), (float[])this.jointWeights, (float[])vw.jointWeights);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("VertexWeights " + this.name + ", diff offsets"), (int[])this.offsets, (int[])vw.offsets);
        if (diff != "") {
            return diff;
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    private int calculateOffsets() {
        int p = 0;
        for (int i = 0; i < this.jcount.length; ++i) {
            this.offsets[i] = p;
            p += this.jcount[i];
        }
        return p;
    }

    public void setJointIndices(int[] jointIndices) {
        this.jointIndices = jointIndices;
    }

    public int[] getJointIndices() {
        return this.jointIndices;
    }

    public void setJointWeights(float[] jointWeights) {
        this.jointWeights = jointWeights;
    }

    public float[] getJointWeights() {
        return this.jointWeights;
    }

    public void setJCounts(int[] jcount) {
        this.jcount = jcount;
        if (jcount != null) {
            this.offsets = new int[jcount.length];
            this.calculateOffsets();
        }
    }

    public int[] getJCounts() {
        return this.jcount;
    }

    protected void remapData(int nrOfDistinctVertices, int[] map) {
        logger.debug("VertexWeights.remapData");
        this.checkAccumulatedWeights(0.1f, 0.05f, true);
        int[] oldVcount = this.jcount;
        int[] oldIndices = this.jointIndices;
        float[] oldWeights = this.jointWeights;
        int[] oldOffsets = this.offsets;
        this.jcount = new int[nrOfDistinctVertices];
        for (int i = 0; i < nrOfDistinctVertices; ++i) {
            this.jcount[i] = oldVcount[map[i]];
        }
        this.offsets = new int[nrOfDistinctVertices];
        int newSize = this.calculateOffsets();
        this.jointIndices = new int[newSize];
        this.jointWeights = new float[newSize];
        for (int i = 0; i < nrOfDistinctVertices; ++i) {
            int oldOffset = oldOffsets[map[i]];
            int newOffset = this.offsets[i];
            int vc = this.jcount[i];
            for (int j = 0; j < vc; ++j) {
                this.jointIndices[newOffset + j] = oldIndices[oldOffset + j];
                this.jointWeights[newOffset + j] = oldWeights[oldOffset + j];
            }
        }
        this.checkAccumulatedWeights(0.1f, 0.05f, true);
    }

    public boolean checkAccumulatedWeights(float epsmin, float epsplus, boolean showdeviations) {
        boolean result = true;
        int p = 0;
        for (int i = 0; i < this.jcount.length; ++i) {
            float accumulatedWeight = 0.0f;
            for (int j = 0; j < this.jcount[i]; ++j) {
                accumulatedWeight += this.jointWeights[p + j];
            }
            if (accumulatedWeight < 1.0f - epsmin || accumulatedWeight > 1.0f + epsplus) {
                result = false;
                if (showdeviations) {
                    logger.error("checkAccumulatedWeights, vertex " + i + " accumulated weight: " + accumulatedWeight);
                }
            }
            p += this.jcount[i];
        }
        return result;
    }

    public float[] getVertexWeightColors(boolean useWeights, float[][] colorCoding) {
        int nrOfVertices = this.jcount.length;
        float[] colors = new float[4 * nrOfVertices];
        float[] accuColor = Vec4f.getVec4f();
        int p = 0;
        for (int i = 0; i < this.jcount.length; ++i) {
            Vec4f.set((float[])accuColor, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            for (int j = 0; j < this.jcount[i]; ++j) {
                int index = this.jointIndices[p + j];
                float w = useWeights ? this.jointWeights[p + j] : 1.0f;
                Vec4f.scaleAdd((float[])accuColor, (float)w, (float[])colorCoding[index], (float[])accuColor);
            }
            Vec4f.set((float[])colors, (int)(4 * i), (float[])accuColor, (int)0);
            p += this.jcount[i];
        }
        return colors;
    }

    public String toString() {
        return this.toXMLString();
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        if (this.jcount != null) {
            VertexWeights.appendIntArrayElement((StringBuilder)buf, (String)"jcount", (int[])this.jcount, (char)' ', (XMLFormatting)fmt, (int)60);
        }
        if (this.jointIndices != null) {
            VertexWeights.appendIntArrayElement((StringBuilder)buf, (String)"jointindices", (int[])this.jointIndices, (char)' ', (XMLFormatting)fmt, (int)60);
        }
        if (this.jointWeights != null) {
            VertexWeights.appendFloatArrayElement((StringBuilder)buf, (String)"jointweights", (float[])this.jointWeights, (char)' ', (XMLFormatting)fmt, (int)30);
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            int count;
            String tag = tokenizer.getTagName();
            if (tag.equals("jcount")) {
                count = this.getRequiredIntAttribute("count", tokenizer.getAttributes(), tokenizer);
                int[] jc = new int[count];
                tokenizer.takeSTag("jcount");
                VertexWeights.decodeIntArray((String)tokenizer.takeOptionalCharData(), (int[])jc);
                this.setJCounts(jc);
                tokenizer.takeETag("jcount");
                continue;
            }
            if (tag.equals("jointindices")) {
                count = this.getRequiredIntAttribute("count", tokenizer.getAttributes(), tokenizer);
                this.jointIndices = new int[count];
                tokenizer.takeSTag("jointindices");
                VertexWeights.decodeIntArray((String)tokenizer.takeOptionalCharData(), (int[])this.jointIndices);
                tokenizer.takeETag("jointindices");
                continue;
            }
            if (tag.equals("jointweights")) {
                count = this.getRequiredIntAttribute("count", tokenizer.getAttributes(), tokenizer);
                this.jointWeights = new float[count];
                tokenizer.takeSTag("jointweights");
                VertexWeights.decodeFloatArray((String)tokenizer.takeOptionalCharData(), (float[])this.jointWeights);
                tokenizer.takeETag("jointweights");
                continue;
            }
            logger.warn(tokenizer.getErrorMessage("VertexWeights: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public void writeBinary(DataOutput dataOut) throws IOException {
        dataOut.writeUTF(this.name);
        BinUtil.writeIntArray((DataOutput)dataOut, (int[])this.jcount);
        BinUtil.writeIntArray((DataOutput)dataOut, (int[])this.jointIndices);
        BinUtil.writeFloatArray((DataOutput)dataOut, (float[])this.jointWeights);
    }

    public void readBinary(DataInput dataIn) throws IOException {
        this.name = dataIn.readUTF().intern();
        this.setJCounts(BinUtil.readIntArray((DataInput)dataIn));
        this.setJointIndices(BinUtil.readIntArray((DataInput)dataIn));
        this.setJointWeights(BinUtil.readFloatArray((DataInput)dataIn));
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

