/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.graphics.scenegraph.GMesh;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GShape;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.graphics.scenegraph.Skeletons;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.BinUtil;
import hmi.util.Diff;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GScene
extends XMLStructureAdapter
implements Diff.Differentiable {
    private String id;
    private List<GNode> rootNodes = new ArrayList<GNode>();
    private List<GSkinnedMesh> skinnedMeshList = new ArrayList<GSkinnedMesh>();
    private List<GNode> skeletonRoots = new ArrayList<GNode>();
    private String xmlVersion = "0.0";
    private static Logger logger = LoggerFactory.getLogger((String)GScene.class.getName());
    private static final String XMLTAG = "gscene";

    public GScene(String id) {
        this.id = id == null ? "" : id.intern();
    }

    public GScene(XMLTokenizer tokenizer) throws IOException {
        this("");
        this.readXML(tokenizer);
    }

    public String getId() {
        return this.id;
    }

    public String showDiff(Object gsceneObj) {
        GScene gscene = (GScene)((Object)gsceneObj);
        if (gscene == null) {
            return "GScene diff: null GScene";
        }
        String diff = Diff.showDiff((String)"GScene diff, rootNodes", this.rootNodes, gscene.rootNodes);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)"GScene diff skinnedMeshList", this.skinnedMeshList, gscene.skinnedMeshList);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)"GScene diff name", this.skeletonRoots, gscene.skeletonRoots);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)"GScene  diff xmlVersion", (String)this.xmlVersion, (String)gscene.xmlVersion);
        if (diff != "") {
            return diff;
        }
        return "";
    }

    public void addRootNode(GNode root) {
        logger.debug("GScene.addRootNode " + root.getId());
        this.rootNodes.add(root);
    }

    public List<GNode> getRootNodes() {
        return this.rootNodes;
    }

    public List<GNode> getSkeletonRoots() {
        return this.skeletonRoots;
    }

    public GNode getPartBySid(String sid) {
        GNode result = null;
        for (GNode rootNode : this.getRootNodes()) {
            result = rootNode.getPartBySid(sid);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public void collectSkinnedMeshes() {
        this.skinnedMeshList = new ArrayList<GSkinnedMesh>();
        for (GNode rtnode : this.rootNodes) {
            ArrayList<GSkinnedMesh> skinnedList = new ArrayList<GSkinnedMesh>();
            this.collectSkinnedMeshes(rtnode, skinnedList);
            this.skinnedMeshList.addAll(skinnedList);
        }
    }

    private void collectSkinnedMeshes(GNode gnode, List<GSkinnedMesh> skinnedList) {
        List<GShape> gshapes = gnode.getGShapes();
        for (GShape gshape : gshapes) {
            GMesh gmesh = gshape.getGMesh();
            if (!(gmesh instanceof GSkinnedMesh)) continue;
            skinnedList.add((GSkinnedMesh)gmesh);
        }
        List<GNode> childNodes = gnode.getChildNodes();
        for (GNode child : childNodes) {
            this.collectSkinnedMeshes(child, skinnedList);
        }
    }

    public void addSkinnedMeshes(List<GSkinnedMesh> skinnedMeshes) {
    }

    public List<GSkinnedMesh> getSkinnedMeshes() {
        return this.skinnedMeshList;
    }

    public void resolveSkinnedMeshJoints() {
        logger.debug("GScene.resolveSkinnedMeshJoints");
        for (GSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.resolveJoints(this.rootNodes);
            GNode[] meshSkeletonRoots = gsm.getSkeletonRoots();
            if (meshSkeletonRoots == null) {
                return;
            }
            for (int i = 0; i < meshSkeletonRoots.length; ++i) {
                GNode skelRoot = meshSkeletonRoots[i];
                if (this.skeletonRoots.contains((Object)skelRoot)) continue;
                this.skeletonRoots.add(skelRoot);
            }
        }
    }

    public void calculateVJointMatrices() {
        for (GNode root : this.rootNodes) {
            root.getVJoint().calculateMatrices();
        }
    }

    public void clearRotations() {
        for (GNode skelRoot : this.skeletonRoots) {
            skelRoot.clearRotations();
        }
    }

    public void rotate(float x, float y, float z, float angle) {
        this.rotateScale(x, y, z, angle, 1.0f);
    }

    public void scale(float scale) {
        this.rotateScale(1.0f, 0.0f, 0.0f, 0.0f, scale);
    }

    public void rotateScale(float x, float y, float z, float angle, float scale) {
        float[] q = Quat4f.getQuat4f();
        Quat4f.setFromAxisAngle4f((float[])q, (float)x, (float)y, (float)z, (float)angle);
        float[] t = Vec3f.getZero();
        this.affineTransform(t, q, scale);
    }

    public void affineTransform(float[] t, float[] q, float s) {
        float[] mat4x4 = Mat4f.getMat4f();
        float[] zerovec = Vec3f.getZero();
        Mat4f.setFromTRS((float[])mat4x4, (float[])zerovec, (float[])q, (float)s);
        for (GNode rootNode : this.rootNodes) {
            rootNode.affineTransform(mat4x4);
        }
    }

    public void renameJoints(Map<String, String> renaming) {
        for (GNode rnode : this.skeletonRoots) {
            rnode.renameJoints(renaming);
        }
        for (GSkinnedMesh skm : this.skinnedMeshList) {
            skm.renameJointSIDs(renaming);
        }
    }

    public void adjustBindPoses() {
        for (GSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.simplifyBindPose();
        }
    }

    public void normalizeMeshes() {
        for (GNode rootGNode : this.getRootNodes()) {
            this.normalizeMeshes(rootGNode);
        }
    }

    public void normalizeMeshes(GNode gnode) {
        for (GShape gshape : gnode.getGShapes()) {
            GMesh gmesh = gshape.getGMesh();
            if (!gmesh.hasUnifiedIndexData()) {
                gmesh.unifyIndices();
            }
            if (gmesh.getMeshType() != GMesh.MeshType.Polylist && gmesh.getMeshType() != GMesh.MeshType.Polygons) continue;
            gmesh.triangulate();
        }
        for (GNode gchild : gnode.getChildNodes()) {
            this.normalizeMeshes(gchild);
        }
    }

    public void analyzeMeshes() {
        for (GNode rootGNode : this.getRootNodes()) {
            this.analyzeMeshes(rootGNode);
        }
    }

    public void analyzeMeshes(GNode gnode) {
        for (GShape gshape : gnode.getGShapes()) {
            GMesh gmesh = gshape.getGMesh();
            logger.debug("Analyze mesh " + gmesh.getId());
            gmesh.analyze();
        }
        for (GNode gchild : gnode.getChildNodes()) {
            this.analyzeMeshes(gchild);
        }
    }

    public void setSkeletonHAnimPoses() {
        for (GNode skeletonRoot : this.skeletonRoots) {
            Skeletons.setHAnimPose(skeletonRoot.getVJoint());
        }
        this.calculateVJointMatrices();
        Skeletons.setNeutralPoses(this.skeletonRoots, this.skinnedMeshList, this.rootNodes);
    }

    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        GScene.appendAttribute((StringBuilder)buf, (String)"version", (String)this.xmlVersion);
        GScene.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.xmlVersion = this.getOptionalAttribute("version", attrMap, "0.0");
        this.id = this.getOptionalAttribute("id", attrMap, "");
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        GScene.appendSTag((StringBuilder)buf, (String)"rootnodes", (XMLFormatting)fmt);
        GScene.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.rootNodes);
        GScene.appendETag((StringBuilder)buf, (String)"rootnodes", (XMLFormatting)fmt);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals("rootnodes")) {
                tokenizer.takeSTag("rootnodes");
                this.rootNodes = GScene.decodeXMLStructureList((XMLTokenizer)tokenizer, (String)"gnode", GNode.class);
                tokenizer.takeETag("rootnodes");
                continue;
            }
            System.out.println(tokenizer.getErrorMessage("Scene: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void writeBinary(DataOutput dataOut) throws IOException {
        BinUtil.writeOptionalString((DataOutput)dataOut, (String)this.xmlVersion);
        BinUtil.writeBinaryList((DataOutput)dataOut, this.getRootNodes());
    }

    public void readBinary(DataInput dataIn) throws IOException {
        this.xmlVersion = BinUtil.readOptionalString((DataInput)dataIn);
        ArrayList rnodes = BinUtil.readBinaryList((DataInput)dataIn, GNode.class);
        if (rnodes == null) {
            this.rootNodes = null;
        } else {
            for (GNode rn : rnodes) {
                this.addRootNode(rn);
            }
        }
    }
}

