/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.state.GLState;
import hmi.graphics.opengl.state.GLStateComponent;

public final class GLStateComponentII
implements GLStateComponent {
    private int glId;
    private int scId;
    private int target;
    private int glEnumi;

    public GLStateComponentII(int target, int glId, int glEnumi) {
        this.glId = glId;
        this.scId = GLState.getSCId(glId);
        this.checkLegal(glId);
        this.target = target;
        this.glEnumi = glEnumi;
    }

    private void checkLegal(int glId) {
        if (glId == 2880 || glId == 2902) {
            return;
        }
        if (33 <= glId && glId < 49) {
            return;
        }
        throw new IllegalArgumentException("GLStateComponentII: unknown glId: " + glId);
    }

    @Override
    public int getSCId() {
        return this.scId;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.glRender(gl);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        if (33 <= this.glId && this.glId < 49) {
            gl.glTexParameteri(this.target, this.glId, this.glEnumi);
        } else if (this.glId == 2902) {
            gl.glColorMaterial(this.target, this.glEnumi);
        } else if (this.glId == 2880) {
            gl.glPolygonMode(this.target, this.glEnumi);
        }
    }

    public String toString() {
        return "<" + GLState.getGLName(this.glId) + " (" + GLState.getGLName(this.target) + ") = " + this.glEnumi + ">";
    }
}

