/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import java.util.HashMap;

public final class GLState {
    private static final HashMap<String, Integer> GLNAMETOGLID = new HashMap();
    private static final HashMap<Integer, String> GLIDTOGLNAME = new HashMap();
    private static final HashMap<Integer, Integer> GLIDTOSCID = new HashMap();
    private static final HashMap<Integer, Integer> SCIDTOGLID = new HashMap();
    private static int lastSCId = 500;
    public static final int LIGHT_GROUP = 1;
    public static final int LIGHT_GROUP_SIZE = 23;
    public static final int MATERIAL_GROUP = 24;
    public static final int MATERIAL_GROUP_SIZE = 9;
    public static final int TEXTURE_GROUP = 33;
    public static final int TEXTURE_GROUP_SIZE = 16;
    public static final int POLYGON_GROUP = 49;
    public static final int POLYGON_GROUP_SIZE = 6;

    private GLState() {
    }

    public static synchronized int createSCId() {
        return ++lastSCId;
    }

    public static synchronized int createSCId(int stateGroup) {
        return ++lastSCId;
    }

    protected static void addStateVariable(String glName, int glId, int scId) {
        GLNAMETOGLID.put(glName, glId);
        GLIDTOGLNAME.put(glId, glName);
        GLIDTOSCID.put(glId, scId);
        SCIDTOGLID.put(scId, glId);
    }

    protected static void addGLName(String glName, int glId) {
        GLNAMETOGLID.put(glName, glId);
        GLIDTOGLNAME.put(glId, glName);
    }

    public static int getSCId(int glId) {
        Integer scId = GLIDTOSCID.get(glId);
        if (scId == null) {
            return -1;
        }
        return scId;
    }

    public static String getGLName(int glId) {
        String glName = GLIDTOGLNAME.get(glId);
        if (glName == null) {
            return "<unknown>";
        }
        return glName;
    }

    public static int getGLId(String glName) {
        Integer glId = GLNAMETOGLID.get(glName);
        if (glId == null) {
            return -1;
        }
        return glId;
    }

    static {
        GLState.addGLName("GL_FALSE", 0);
        GLState.addGLName("GL_TRUE", 1);
        GLState.addGLName("GL_SINGLE_COLOR", 33273);
        GLState.addGLName("GL_SEPARATE_SPECULAR_COLOR", 33274);
        GLState.addGLName("GL_FRONT", 1028);
        GLState.addGLName("GL_BACK", 1029);
        GLState.addGLName("GL_FRONT_AND_BACK", 1032);
        GLState.addGLName("GL_CCW", 2305);
        GLState.addGLName("GL_CW", 2304);
        GLState.addGLName("GL_POINT", 6912);
        GLState.addGLName("GL_LINE", 6913);
        GLState.addGLName("GL_FILL", 6914);
        GLState.addGLName("GL_TEXTURE0", 33984);
        GLState.addGLName("GL_TEXTURE1", 33985);
        GLState.addGLName("GL_TEXTURE2", 33986);
        GLState.addGLName("GL_TEXTURE3", 33987);
        GLState.addGLName("GL_TEXTURE4", 33988);
        GLState.addGLName("GL_TEXTURE5", 33989);
        GLState.addGLName("GL_TEXTURE6", 33990);
        GLState.addGLName("GL_TEXTURE7", 33991);
        GLState.addGLName("GL_NEAREST", 9728);
        GLState.addGLName("GL_LINEAR", 9729);
        GLState.addGLName("GL_NEAREST_MIPMAP_NEAREST", 9984);
        GLState.addGLName("GL_NEAREST_MIPMAP_LINEAR", 9986);
        GLState.addGLName("GL_LINEAR_MIPMAP_NEAREST", 9985);
        GLState.addGLName("GL_LINEAR_MIPMAP_LINEAR", 9987);
        GLState.addGLName("GL_REPEAT", 10497);
        GLState.addGLName("GL_MIRROREDREPEAT", 33648);
        GLState.addGLName("GL_CLAMP", 10496);
        GLState.addGLName("GL_CLAMP_TO_BORDER", 33069);
        GLState.addGLName("GL_CLAMP_TO_EDGE", 33071);
        GLState.addGLName("GL_MODULATE", 8448);
        GLState.addGLName("GL_BLEND", 3042);
        GLState.addGLName("GL_REPLACE", 7681);
        GLState.addGLName("GL_DECAL", 8449);
        GLState.addGLName("GL_ADD", 260);
        GLState.addGLName("GL_COMBINE", 34160);
        GLState.addStateVariable("GL_LIGHTING", 2896, 1);
        GLState.addStateVariable("GL_LIGHT_MODEL_AMBIENT", 2899, 2);
        GLState.addStateVariable("GL_LIGHT_MODEL_LOCAL_VIEWER", 2897, 3);
        GLState.addStateVariable("GL_LIGHT_MODEL_TWO_SIDE", 2898, 4);
        GLState.addStateVariable("GL_LIGHT_MODEL_COLOR_CONTROL", 33272, 5);
        GLState.addStateVariable("GL_AMBIENT", 4608, 6);
        GLState.addStateVariable("GL_DIFFUSE", 4609, 7);
        GLState.addStateVariable("GL_SPECULAR", 4610, 8);
        GLState.addStateVariable("GL_POSITION", 4611, 9);
        GLState.addStateVariable("GL_SPOT_DIRECTION", 4612, 10);
        GLState.addStateVariable("GL_SPOT_EXPONENT", 4613, 11);
        GLState.addStateVariable("GL_SPOT_CUTOFF", 4614, 12);
        GLState.addStateVariable("GL_CONSTANT_ATTENUATION", 4615, 13);
        GLState.addStateVariable("GL_LINEAR_ATTENUATION", 4616, 14);
        GLState.addStateVariable("GL_QUADRATIC_ATTENUATION", 4617, 15);
        GLState.addStateVariable("GL_LIGHT0", 16384, 16);
        GLState.addStateVariable("GL_LIGHT1", 16385, 17);
        GLState.addStateVariable("GL_LIGHT2", 16386, 18);
        GLState.addStateVariable("GL_LIGHT3", 16387, 19);
        GLState.addStateVariable("GL_LIGHT4", 16388, 20);
        GLState.addStateVariable("GL_LIGHT5", 16389, 21);
        GLState.addStateVariable("GL_LIGHT6", 16390, 22);
        GLState.addStateVariable("GL_LIGHT7", 16391, 23);
        GLState.addStateVariable("GL_COLOR_MATERIAL", 2903, 24);
        GLState.addStateVariable("GL_COLOR_MATERIAL_PARAMETER", 2902, 25);
        GLState.addStateVariable("GL_COLOR_MATERIAL_FACE", 2901, 26);
        GLState.addStateVariable("GL_AMBIENT", 4608, 27);
        GLState.addStateVariable("GL_DIFFUSE", 4609, 28);
        GLState.addStateVariable("GL_AMBIENT_AND_DIFFUSE", 5634, 29);
        GLState.addStateVariable("GL_SPECULAR", 4610, 30);
        GLState.addStateVariable("GL_EMISSION", 5632, 31);
        GLState.addStateVariable("GL_SHININESS", 5633, 32);
        GLState.addStateVariable("GL_ACTIVE_TEXTURE", 34016, 33);
        GLState.addStateVariable("GL_TEXTURE_MIN_FILTER", 10241, 34);
        GLState.addStateVariable("GL_TEXTURE_MAG_FILTER", 10240, 35);
        GLState.addStateVariable("GL_TEXTURE_MIN_LOD", 33082, 36);
        GLState.addStateVariable("GL_TEXTURE_MAX_LOD", 33083, 37);
        GLState.addStateVariable("GL_TEXTURE_BASE_LEVEL", 33084, 38);
        GLState.addStateVariable("GL_TEXTURE_MAX_LEVEL", 33085, 39);
        GLState.addStateVariable("GL_TEXTURE_WRAP_S", 10242, 40);
        GLState.addStateVariable("GL_TEXTURE_WRAP_T", 10243, 41);
        GLState.addStateVariable("GL_TEXTURE_WRAP_R", 32882, 42);
        GLState.addStateVariable("GL_TEXTURE_BORDER_COLOR", 4100, 43);
        GLState.addStateVariable("GL_GENERATE_MIPMAP", 33169, 44);
        GLState.addStateVariable("GL_TEXTURE_ENV_MODE", 8704, 45);
        GLState.addStateVariable("GL_TEXTURE_1D", 3552, 46);
        GLState.addStateVariable("GL_TEXTURE_2D", 3553, 47);
        GLState.addStateVariable("GL_TEXTURE_3D", 32879, 48);
        GLState.addStateVariable("GL_POLYGON_MODE", 2880, 49);
        GLState.addStateVariable("GL_POLYGON_SMOOTH", 2881, 50);
        GLState.addStateVariable("GL_POLYGON_OFFSET_FACTOR", 32824, 51);
        GLState.addStateVariable("GL_POLYGON_OFFSET_POINT", 10753, 52);
        GLState.addStateVariable("GL_POLYGON_OFFSET_LINE", 10754, 53);
        GLState.addStateVariable("GL_POLYGON_OFFSET_FILL", 32823, 54);
    }
}

