/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLUtil;
import java.util.ArrayList;

public class VGLNode
implements GLRenderObject {
    private VJoint root;
    private GLRenderList shapeList;
    private static final ArrayList<VGLNode> EMPTYLIST = new ArrayList(0);
    private ArrayList<VGLNode> children = EMPTYLIST;
    private static final boolean collectShapes = false;
    private static boolean showDetail = true;

    public VGLNode(String name) {
        this(name, 1);
    }

    public VGLNode(String name, int capacity) {
        this.root = new VJoint(name);
        this.shapeList = new GLRenderList(capacity);
    }

    public VGLNode(VJoint root, GLRenderList shapeList) {
        this.root = root;
        this.shapeList = shapeList;
    }

    public String getName() {
        return this.root == null ? "" : this.root.getName();
    }

    public GLRenderList getGLShapeList() {
        return this.shapeList;
    }

    public void addGLShapeList(GLRenderList shapeList) {
        this.shapeList.addAll(shapeList);
    }

    public VJoint getRoot() {
        return this.root;
    }

    public void prependGLShape(GLShape glShape) {
        this.shapeList.prepend(glShape);
    }

    public void addGLShape(GLShape glShape) {
        this.shapeList.add(glShape);
        glShape.linkToTransformMatrix(this.root.getGlobalMatrix());
    }

    public void addChild(VGLNode childNode) {
        this.root.addChild(childNode.root);
        if (this.children == EMPTYLIST) {
            this.children = new ArrayList();
        }
        this.children.add(childNode);
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.shapeList.glInit(gl);
        for (VGLNode child : this.children) {
            child.glInit(gl);
        }
    }

    @Override
    public void glRender(GLRenderContext gl) {
        this.shapeList.glRender(gl);
        for (VGLNode child : this.children) {
            child.glRender(gl);
        }
    }

    public static void setShowDetail(boolean show) {
        showDetail = show;
    }

    public boolean showDetail() {
        return showDetail;
    }

    public StringBuilder appendTo(StringBuilder buf, int tab) {
        GLUtil.appendSpacesString(buf, tab, "VGLNode ");
        buf.append(this.getName());
        if (this.showDetail()) {
            this.root.appendTo(buf, tab + GLUtil.TAB);
        }
        buf.append('\n');
        this.shapeList.appendTo(buf, tab + GLUtil.TAB);
        for (VGLNode child : this.children) {
            child.appendTo(buf, tab + GLUtil.TAB);
        }
        return buf;
    }

    public String toString() {
        StringBuilder buf = this.appendTo(new StringBuilder(), 0);
        return buf.toString();
    }
}

