/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLBasicMesh;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLSkinnedMesh;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.GMaterialTranslator;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.scenegraph.GMaterial;
import hmi.graphics.scenegraph.GMesh;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.scenegraph.GShape;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.graphics.scenegraph.VertexAttribute;
import hmi.graphics.scenegraph.VertexWeights;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScenegraphTranslator {
    private static Logger logger = LoggerFactory.getLogger((String)ScenegraphTranslator.class.getName());
    private static boolean addVertexWeightColors = false;

    private ScenegraphTranslator() {
    }

    public static GLScene fromGSceneToGLScene(GScene gscene) {
        GLScene glScene = new GLScene(gscene.getId());
        List<GNode> rootGNodes = gscene.getRootNodes();
        for (GNode rootGNode : rootGNodes) {
            GLRenderList shapeList = new GLRenderList();
            ArrayList<GLSkinnedMesh> skinnedMeshes = new ArrayList<GLSkinnedMesh>();
            VJoint root = ScenegraphTranslator.fromGNodeToVJoint(rootGNode, shapeList, skinnedMeshes);
            glScene.addVJointRoot(root);
            glScene.addGLShapes(shapeList);
            glScene.addSkinnedMeshes(skinnedMeshes);
        }
        return glScene;
    }

    public static GLBasicMesh fromGMeshToGLBasicMesh(GMesh gmesh) {
        GLBasicMesh glbm = new GLBasicMesh();
        ScenegraphTranslator.addGLBasicMeshAttributes(gmesh, glbm);
        glbm.setId(gmesh.getId());
        return glbm;
    }

    public static GLSkinnedMesh fromGSkinnedMeshToGLSkinnedMesh(GSkinnedMesh gmesh) {
        GLSkinnedMesh glsm = new GLSkinnedMesh();
        ScenegraphTranslator.addGLBasicMeshAttributes(gmesh, glsm);
        glsm.setId(gmesh.getId());
        glsm.setJointSIDs(gmesh.getJointSIDs());
        glsm.setJointNames(gmesh.getJointNames());
        glsm.setVJoints(gmesh.getVJoints());
        glsm.setInverseBindMatrices(gmesh.getInvBindMatrices());
        glsm.setParentIndex(gmesh.getParentIndex());
        VertexWeights vw = gmesh.getVertexWeights();
        glsm.setJointVertexWeights(vw.getJCounts(), vw.getJointIndices(), vw.getJointWeights());
        List<String> attrnames = gmesh.getVertexAttributeNameList(-1);
        String[] morphTargets = gmesh.getMorphTargets();
        if (morphTargets != null) {
            gmesh.checkMorphTargetConsistency("texCoord1");
            glsm.setMorphTargets(morphTargets);
            float[][] morphData = gmesh.getMorphData("mcPosition");
            if (morphData == null) {
                logger.error(gmesh.getId() + ": Morphed mesh with null morph data");
            } else {
                glsm.setVertexCoordMorphData(morphData);
            }
        }
        return glsm;
    }

    private static void addGLBasicMeshAttributes(GMesh gmesh, GLBasicMesh glmesh) {
        glmesh.setIndexData(gmesh.getIndexData());
        ArrayList<VertexAttribute> attributeList = gmesh.getVertexAttributeList();
        if (addVertexWeightColors) {
            GSkinnedMesh gm = (GSkinnedMesh)gmesh;
            float[][] colorCoding = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 1.0f}};
            String[] coloredJoints = new String[]{"Bone2", "Bone1"};
            gm.addVertexWeightColors(true, coloredJoints, colorCoding);
        }
        for (VertexAttribute va : attributeList) {
            glmesh.addGLVertexAttribute(va);
        }
    }

    public static GLShape fromGShapeToGLShape(GShape gshape, List<GLSkinnedMesh> glSkinnedMeshes) {
        GMesh gmesh = gshape.getGMesh();
        GLShape glshape = new GLShape(gshape.getName());
        GMaterial gmaterial = gshape.getGMaterial();
        GLMaterial glmaterial = GMaterialTranslator.fromGMaterialToGLMaterial(gmaterial);
        glshape.addGLState(glmaterial);
        if (gmesh instanceof GSkinnedMesh) {
            GSkinnedMesh gsm = (GSkinnedMesh)gmesh;
            GLSkinnedMesh glsm = ScenegraphTranslator.fromGSkinnedMeshToGLSkinnedMesh(gsm);
            glshape.addGLGeometry(glsm);
            glSkinnedMeshes.add(glsm);
        } else {
            GLBasicMesh glbm = ScenegraphTranslator.fromGMeshToGLBasicMesh(gmesh);
            glshape.addGLGeometry(glbm);
        }
        return glshape;
    }

    public static VJoint fromGNodeToVJoint(GNode gnode, GLRenderList glShapeList, List<GLSkinnedMesh> glSkinnedMeshes) {
        List<GNode> gnodeList;
        VJoint vjoint = gnode.getVJoint();
        float[] jointMatrix = vjoint.getGlobalMatrix();
        List<GShape> gshapeList = gnode.getGShapes();
        if (gshapeList != null) {
            for (GShape gshape : gshapeList) {
                GLShape glshape = ScenegraphTranslator.fromGShapeToGLShape(gshape, glSkinnedMeshes);
                glshape.linkToTransformMatrix(jointMatrix);
                glShapeList.add(glshape);
            }
        }
        if ((gnodeList = gnode.getChildNodes()) != null) {
            for (GNode gchild : gnodeList) {
                ScenegraphTranslator.fromGNodeToVJoint(gchild, glShapeList, glSkinnedMeshes);
            }
        }
        return vjoint;
    }
}

