/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.scenegraph;

import hmi.graphics.opengl.GLShader;
import hmi.graphics.opengl.GLTexture;
import hmi.graphics.opengl.GLTextureLoader;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.scenegraph.GMaterial;
import hmi.graphics.scenegraph.GTexture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GMaterialTranslator {
    private static Logger logger = LoggerFactory.getLogger((String)GMaterialTranslator.class.getName());

    private GMaterialTranslator() {
    }

    public static GLMaterial fromGMaterialToGLMaterial(GMaterial gmaterial) {
        String shader;
        logger.debug("GMaterialTranslator.GMaterialToGLMaterial");
        GLMaterial glmaterial = new GLMaterial(gmaterial.getName());
        glmaterial.setEmissionColor(gmaterial.getEmissionColor());
        glmaterial.setAmbientColor(gmaterial.getAmbientColor());
        glmaterial.setDiffuseColor(gmaterial.getDiffuseColor());
        glmaterial.setSpecularColor(gmaterial.getSpecularColor());
        glmaterial.setShininess(gmaterial.getShininess());
        GTexture gDiffuseTex = gmaterial.getDiffuseTexture();
        if (gDiffuseTex != null) {
            int texUnit = 0;
            GLTexture glDiffuseTex = GMaterialTranslator.fromGTextureToGLTexture(gDiffuseTex, texUnit, glmaterial.getName());
            glmaterial.setDiffuseTexture(glDiffuseTex, texUnit);
        }
        glmaterial.setRepeatS(gmaterial.getRepeatS());
        glmaterial.setRepeatT(gmaterial.getRepeatT());
        glmaterial.setOffsetS(gmaterial.getOffsetS());
        glmaterial.setOffsetT(gmaterial.getOffsetT());
        if (gmaterial.isTransparencyEnabled()) {
            GTexture gTransparantTex;
            logger.debug("GMaterialTranslator, transparency enabled for " + gmaterial.getName());
            glmaterial.setAlphaBlendingEnabled(true);
            glmaterial.setBlendSrcFactor(770);
            glmaterial.setBlendDestFactor(771);
            float[] transparentColor = gmaterial.getTransparentColor();
            if (transparentColor != null) {
                glmaterial.setTransparentColor(transparentColor);
            }
            if ((gTransparantTex = gmaterial.getTransparentTexture()) != null) {
                int texUnit = gDiffuseTex == null ? 0 : 1;
                GLTexture glTransparantTex = GMaterialTranslator.fromGTextureToGLTexture(gTransparantTex, texUnit, glmaterial.getName());
                glmaterial.setTransparantTexture(glTransparantTex, texUnit);
            }
        }
        if ((shader = gmaterial.getShader()) != null) {
            GLShader glShader = new GLShader(shader, new String[0]);
            glmaterial.setGLShader(glShader);
        }
        return glmaterial;
    }

    public static GLTexture fromGTextureToGLTexture(GTexture gtex, int texUnit, String materialName) {
        boolean rescale;
        boolean flip;
        String imageName = gtex.getImageFileName();
        String texName = imageName;
        GLTexture texture = GLTextureLoader.getGLTexture(texUnit, texName, flip = true, rescale = true);
        if (texture == null) {
            logger.error("GTextureToGLTexture for GLMaterial " + materialName + ": Could not load texture \"" + texName + "\"");
        } else {
            texture.setImageFileName(imageName);
        }
        return texture;
    }
}

