/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.renderobjects;

import com.sun.opengl.util.GLUT;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;

public class SimpleLight
implements GLRenderObject {
    private float[] ambient = new float[4];
    private float[] diffuse = new float[4];
    private float[] specular = new float[4];
    private float[] position = new float[4];
    private float[] origin = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float linAtt = 0.0f;
    private boolean enabled = true;
    private boolean visible = false;
    private int gl_light;
    private int index;
    float lightRadius = 1.0f;
    private GLUT glut;
    private int displayList;

    public SimpleLight(int index) {
        this.setAmbientColor(0.0f, 0.0f, 0.0f);
        this.setDiffuseColor(1.0f, 1.0f, 1.0f);
        this.setSpecularColor(0.0f, 0.0f, 0.0f);
        this.setLinearAttenuation(0.0f);
        this.setDirection(0.0f, 0.0f, 1.0f);
        this.index = index;
        this.gl_light = 16384 + index;
        this.enabled = true;
    }

    public int getIndex() {
        return this.index;
    }

    public void setRadius(float r) {
        this.lightRadius = r;
    }

    public void setAmbientColor(float r, float g, float b) {
        this.ambient[0] = r;
        this.ambient[1] = g;
        this.ambient[2] = b;
        this.ambient[3] = 1.0f;
    }

    public void setDiffuseColor(float r, float g, float b) {
        this.diffuse[0] = r;
        this.diffuse[1] = g;
        this.diffuse[2] = b;
        this.diffuse[3] = 1.0f;
    }

    public void setSpecularColor(float r, float g, float b) {
        this.specular[0] = r;
        this.specular[1] = g;
        this.specular[2] = b;
        this.specular[3] = 1.0f;
    }

    public void setLinearAttenuation(float attenuation) {
        this.linAtt = attenuation;
    }

    public void setPosition(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        this.position[3] = 1.0f;
    }

    public void setPosition(float[] pos) {
        this.setPosition(pos[0], pos[1], pos[2]);
    }

    public float[] getPosition() {
        return this.position;
    }

    public void setDirection(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        this.position[3] = 0.0f;
    }

    public synchronized void setEnabled(boolean e) {
        this.enabled = e;
    }

    public synchronized void setVisible(boolean vis) {
        this.visible = vis;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        gl.glLightfv(this.gl_light, 4608, this.ambient);
        gl.glLightfv(this.gl_light, 4609, this.diffuse);
        gl.glLightfv(this.gl_light, 4610, this.specular);
        if ((double)this.linAtt != 0.0) {
            gl.glLightf(this.gl_light, 4616, this.linAtt);
        }
        if (this.enabled) {
            gl.glEnable(this.gl_light);
        } else {
            gl.glDisable(this.gl_light);
        }
        this.glut = new GLUT();
        this.displayList = gl.glGenLists(1);
        gl.glNewList(this.displayList, 4864);
        gl.glMaterialfv(1028, 5632, this.diffuse);
        this.glut.glutSolidSphere((double)this.lightRadius, 32, 32);
        gl.glEndList();
    }

    @Override
    public void glRender(GLRenderContext gl) {
        if (!this.enabled) {
            return;
        }
        if (this.visible) {
            gl.glUseProgram(0);
            gl.glPushMatrix();
            gl.glTranslatef(this.position[0], this.position[1], this.position[2]);
            gl.glCallList(this.displayList);
            gl.glPopMatrix();
        }
        gl.glLightfv(this.gl_light, 4611, this.position);
    }
}

