/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.renderobjects;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.renderobjects.GLNavigation2;
import hmi.graphics.opengl.renderobjects.SimpleLight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightBox
implements GLRenderObject {
    private static Logger logger = LoggerFactory.getLogger((String)LightBox.class.getName());
    private int numLights = 0;
    public static final int MAX_NUM_LIGHTS = 8;
    private SimpleLight[] light = new SimpleLight[8];
    private GLNavigation2 control;

    public LightBox() {
        this(0);
    }

    public LightBox(int numberOfLights) {
        if (numberOfLights < 0 || numberOfLights > 8) {
            logger.error("LightBox: numLights should be between 0 and 8");
        }
        for (int i = 0; i < numberOfLights; ++i) {
            this.addLight();
        }
    }

    @Override
    public void glInit(GLRenderContext gl) {
        for (int i = 0; i < this.numLights; ++i) {
            this.light[i].glInit(gl);
        }
    }

    @Override
    public void glRender(GLRenderContext gl) {
        for (int i = 0; i < this.numLights; ++i) {
            this.light[i].glRender(gl);
        }
    }

    private void addLight() {
        int i = this.numLights++;
        this.light[i] = new SimpleLight(i);
        this.light[i].setAmbientColor(0.0f, 0.0f, 0.0f);
        this.light[i].setSpecularColor(0.0f, 0.0f, 0.0f);
        this.light[i].setDiffuseColor(0.0f, 0.0f, 0.0f);
        this.light[i].setRadius(0.02f);
        this.light[i].setPosition(0.0f, 2.0f, 0.0f);
        this.light[i].setVisible(false);
        if (this.control != null) {
            this.control.addControl(i, this.light[i].getPosition());
        }
    }

    public void setControl(GLNavigation2 glNav) {
        this.control = glNav;
        for (int i = 0; i < this.numLights; ++i) {
            this.control.addLightControl(this.light[i]);
        }
    }

    public SimpleLight get(int i) {
        return this.light[i];
    }
}

